/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.text;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;

public interface CharArray {
    public int getLength();

    public void write(OutputStream var1) throws IOException, NullPointerException;

    public void write(Appendable var1) throws IOException, NullPointerException;

    public static class Simple
    implements CharArray {
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private final CharSequence chars;
        private final byte[] bytes;

        public Simple(CharSequence sequence) {
            try {
                this.chars = sequence;
                this.bytes = UTF_8.newEncoder().encode(CharBuffer.wrap(this.chars)).array();
            }
            catch (CharacterCodingException e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        public int getLength() {
            return this.chars.length();
        }

        public void write(OutputStream out) throws IOException, NullPointerException {
            if (out == null) {
                throw new NullPointerException("No null dst argument accepted");
            }
            out.write(this.bytes);
        }

        public void write(Appendable appendable) throws IOException {
            if (appendable == null) {
                throw new NullPointerException("No null dst argument accepted");
            }
            appendable.append(this.chars);
        }
    }
}

