/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String lineSep = System.getProperty("line.separator");
    private static final ThreadLocal<StringBuilder> currentLog = new ThreadLocal();
    private static final ThreadLocal<DateFormat> format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("h:mm:ss:SSS");
        }
    };
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static final Logger logger = BaseProcessor.getLogger(BaseProcessor.class);
    private boolean formalErrorReporting = false;

    public static Logger getLogger(Class<?> type) {
        String key = type.getName();
        final String name = type.getSimpleName();
        Logger logger = loggers.get(key);
        if (logger == null) {
            logger = new Logger(){

                public void log(CharSequence msg) {
                    BaseProcessor.log(name, msg);
                }

                public void log(CharSequence msg, Throwable t) {
                    BaseProcessor.log(name, msg, t);
                }
            };
            loggers.put(key, logger);
        }
        return logger;
    }

    private static void log(String name, CharSequence msg) {
        String s = format.get().format(new Date());
        currentLog.get().append(s).append(" ").append("[").append(name).append("] ").append(msg).append(lineSep);
    }

    private static void log(String name, CharSequence msg, Throwable t) {
        StringWriter buffer = new StringWriter();
        t.printStackTrace(new PrintWriter(buffer));
        BaseProcessor.log(name, msg);
        currentLog.get().append(buffer);
    }

    protected BaseProcessor() {
    }

    public boolean getFormalErrorReporting() {
        return this.formalErrorReporting;
    }

    public void setFormalErrorReporting(boolean formalErrorReporting) {
        this.formalErrorReporting = formalErrorReporting;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        currentLog.set(new StringBuilder());
        this.doInit(processingEnv);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    protected void doInit(ProcessingEnvironment processingEnv) {
    }

    protected ErrorCode decode(String key) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block31: {
            String s22;
            String t22;
            block32: {
                this.doProcess(annotations, roundEnv);
                Object var10_3 = null;
                if (!roundEnv.processingOver()) break block31;
                t22 = currentLog.get().toString();
                currentLog.set(null);
                if (t22.length() <= 0) break block31;
                s22 = null;
                InputStream in = null;
                try {
                    FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "processor.log");
                    in = file.openInputStream();
                    s22 = Tools.read(in, "UTF-8");
                    Object var16_18 = null;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    Tools.safeClose(in);
                    throw throwable;
                }
                Tools.safeClose(in);
                {
                    break block32;
                    catch (Exception ignore) {
                        Object var16_19 = null;
                        Tools.safeClose(in);
                    }
                }
            }
            OutputStream out = null;
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "processor.log", new Element[0]);
                out = file.openOutputStream();
                if (s22 != null) {
                    out.write(s22.getBytes("UTF-8"));
                }
                out.write(t22.getBytes("UTF-8"));
                Object var18_36 = null;
            }
            catch (Throwable throwable) {
                Object var18_38 = null;
                Tools.safeClose(out);
                throw throwable;
            }
            Tools.safeClose(out);
            {
                break block31;
                catch (Exception ignore) {
                    Object var18_37 = null;
                    Tools.safeClose(out);
                    break block31;
                }
            }
            {
                catch (Exception e) {
                    String s22;
                    String t22;
                    block33: {
                        Element element;
                        StringBuilder msg;
                        if (e instanceof CompilationException) {
                            CompilationException ce = (CompilationException)e;
                            if (this.formalErrorReporting) {
                                msg = new StringBuilder("[").append(ce.getCode().getKey()).append("](");
                                Object[] args = ce.getArguments();
                                for (int i = 0; i < args.length; ++i) {
                                    if (i > 0) {
                                        msg.append(',');
                                    }
                                    msg.append(String.valueOf(args[i]));
                                }
                                msg.append(")");
                            } else {
                                msg = new StringBuilder();
                                new Formatter(msg).format(Locale.getDefault(), ce.getCode().getMessage(), ce.getArguments()).flush();
                            }
                            element = ce.getElement();
                        } else {
                            msg = e.getMessage() == null ? new StringBuilder("Exception : ").append(e.getClass().getName()) : new StringBuilder(e.getMessage());
                            element = null;
                        }
                        StringWriter writer = new StringWriter();
                        writer.append(msg).append("\n");
                        e.printStackTrace(new PrintWriter(writer));
                        logger.log(writer.getBuffer());
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                        Object var10_4 = null;
                        if (!roundEnv.processingOver()) break block31;
                        t22 = currentLog.get().toString();
                        currentLog.set(null);
                        if (t22.length() <= 0) break block31;
                        s22 = null;
                        InputStream in = null;
                        try {
                            FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "processor.log");
                            in = file.openInputStream();
                            s22 = Tools.read(in, "UTF-8");
                            Object var16_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var16_23 = null;
                            Tools.safeClose(in);
                            throw throwable;
                        }
                        Tools.safeClose(in);
                        {
                            break block33;
                            catch (Exception ignore) {
                                Object var16_22 = null;
                                Tools.safeClose(in);
                            }
                        }
                    }
                    out = null;
                    try {
                        FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "processor.log", new Element[0]);
                        out = file.openOutputStream();
                        if (s22 != null) {
                            out.write(s22.getBytes("UTF-8"));
                        }
                        out.write(t22.getBytes("UTF-8"));
                        Object var18_39 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_41 = null;
                        Tools.safeClose(out);
                        throw throwable;
                    }
                    Tools.safeClose(out);
                    {
                        break block31;
                        catch (Exception ignore) {
                            Object var18_40 = null;
                            Tools.safeClose(out);
                            break block31;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block35: {
                    Object var10_5 = null;
                    if (roundEnv.processingOver()) {
                        String t22 = currentLog.get().toString();
                        currentLog.set(null);
                        if (t22.length() > 0) {
                            String s22;
                            block34: {
                                s22 = null;
                                InputStream in = null;
                                try {
                                    FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "processor.log");
                                    in = file.openInputStream();
                                    s22 = Tools.read(in, "UTF-8");
                                    Object var16_24 = null;
                                }
                                catch (Throwable throwable2) {
                                    Object var16_26 = null;
                                    Tools.safeClose(in);
                                    throw throwable2;
                                }
                                Tools.safeClose(in);
                                {
                                    break block34;
                                    catch (Exception ignore) {
                                        Object var16_25 = null;
                                        Tools.safeClose(in);
                                    }
                                }
                            }
                            out = null;
                            try {
                                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "processor.log", new Element[0]);
                                out = file.openOutputStream();
                                if (s22 != null) {
                                    out.write(s22.getBytes("UTF-8"));
                                }
                                out.write(t22.getBytes("UTF-8"));
                                Object var18_42 = null;
                            }
                            catch (Throwable throwable3) {
                                Object var18_44 = null;
                                Tools.safeClose(out);
                                throw throwable3;
                            }
                            Tools.safeClose(out);
                            {
                                break block35;
                                catch (Exception ignore) {
                                    Object var18_43 = null;
                                    Tools.safeClose(out);
                                }
                            }
                        }
                    }
                }
                throw throwable;
            }
        }
        return false;
    }

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws CompilationException;
}

