/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.meta;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.meta.ApplicationMetaModel;
import org.juzu.impl.model.meta.MetaModel;
import org.juzu.impl.model.meta.MetaModelObject;
import org.juzu.impl.model.meta.MethodMetaModel;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.JSON;
import org.juzu.metadata.Cardinality;
import org.juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerMetaModel
extends MetaModelObject {
    boolean modified;
    final MetaModel context;
    ApplicationMetaModel application;
    final ElementHandle.Class handle;
    final LinkedHashMap<ElementHandle.Method, MethodMetaModel> methods;

    public ControllerMetaModel(MetaModel context, ElementHandle.Class handle) {
        this.context = context;
        this.handle = handle;
        this.methods = new LinkedHashMap();
        this.modified = false;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.add("handle", this.handle);
        json.add("methods", this.methods.values());
        json.add("application", this.application == null ? null : this.application.handle);
        return json;
    }

    public ApplicationMetaModel getApplication() {
        return this.application;
    }

    public ElementHandle.Class getHandle() {
        return this.handle;
    }

    public List<MethodMetaModel> getMethods() {
        return new ArrayList<MethodMetaModel>(this.methods.values());
    }

    public MethodMetaModel addMethod(Phase phase, String name, Iterable<Map.Entry<String, String>> parameters) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        ArrayList<Cardinality> parameterCardinalities = new ArrayList<Cardinality>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters) {
            parameterTypes.add(entry.getValue());
            parameterCardinalities.add(Cardinality.SINGLE);
            parameterNames.add(entry.getKey());
        }
        ElementHandle.Method handle = ElementHandle.Method.create(this.handle.getFQN(), name, parameterTypes);
        if (this.methods.containsKey(handle)) {
            throw new IllegalStateException();
        }
        MethodMetaModel method = new MethodMetaModel(handle, this, null, phase, name, parameterTypes, parameterCardinalities, parameterNames);
        this.methods.put(handle, method);
        return method;
    }

    void addMethod(ExecutableElement methodElt, String annotationName, Map<String, Object> annotationValues) {
        String id = (String)annotationValues.get("id");
        for (Phase phase : Phase.values()) {
            if (!phase.annotation.getSimpleName().equals(annotationName)) continue;
            List<? extends TypeMirror> parameterTypeMirrors = ((ExecutableType)methodElt.asType()).getParameterTypes();
            List<? extends VariableElement> parameterVariableElements = methodElt.getParameters();
            ArrayList<String> parameterTypes = new ArrayList<String>();
            ArrayList<String> parameterNames = new ArrayList<String>();
            ArrayList<Cardinality> parameterCardinalities = new ArrayList<Cardinality>();
            for (int i = 0; i < parameterTypeMirrors.size(); ++i) {
                TypeMirror parameterSimpleTypeMirror;
                Cardinality cardinality;
                VariableElement parameterVariableElement = parameterVariableElements.get(i);
                TypeMirror parameterTypeMirror = parameterTypeMirrors.get(i);
                TypeMirror erasedParameterTypeMirror = this.context.env.erasure(parameterTypeMirror);
                parameterTypes.add(((Object)erasedParameterTypeMirror).toString());
                switch (parameterTypeMirror.getKind()) {
                    case DECLARED: {
                        DeclaredType dt = (DeclaredType)parameterTypeMirror;
                        TypeElement col = this.context.env.getTypeElement("java.util.List");
                        TypeMirror tm = this.context.env.erasure(col.asType());
                        TypeMirror err = this.context.env.erasure(dt);
                        if (((Object)err).equals(tm)) {
                            if (dt.getTypeArguments().size() != 1) {
                                throw new CompilationException(parameterVariableElement, (ErrorCode)CompilationErrorCode.CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED, new Object[0]);
                            }
                            cardinality = Cardinality.LIST;
                            parameterSimpleTypeMirror = dt.getTypeArguments().get(0);
                            break;
                        }
                        cardinality = Cardinality.SINGLE;
                        parameterSimpleTypeMirror = parameterTypeMirror;
                        break;
                    }
                    case ARRAY: {
                        ArrayType arrayType = (ArrayType)parameterTypeMirror;
                        cardinality = Cardinality.ARRAY;
                        parameterSimpleTypeMirror = arrayType.getComponentType();
                        break;
                    }
                    default: {
                        throw new CompilationException(parameterVariableElement, (ErrorCode)CompilationErrorCode.CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED, new Object[0]);
                    }
                }
                if (parameterSimpleTypeMirror.getKind() != TypeKind.DECLARED) {
                    throw new CompilationException(parameterVariableElement, (ErrorCode)CompilationErrorCode.CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED, new Object[0]);
                }
                DeclaredType parameterSimpleType = (DeclaredType)parameterSimpleTypeMirror;
                if (!parameterSimpleType.asElement().toString().equals("java.lang.String")) {
                    throw new CompilationException(parameterVariableElement, (ErrorCode)CompilationErrorCode.CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED, new Object[0]);
                }
                parameterCardinalities.add(cardinality);
                parameterNames.add(parameterVariableElement.getSimpleName().toString());
            }
            ElementHandle.Method origin = ElementHandle.Method.create(methodElt);
            this.methods.remove(origin);
            for (MethodMetaModel existing : this.methods.values()) {
                if (existing.id == null || !existing.id.equals(id)) continue;
                throw new CompilationException(methodElt, (ErrorCode)CompilationErrorCode.CONTROLLER_METHOD_DUPLICATE_ID, id);
            }
            MethodMetaModel method = new MethodMetaModel(origin, this, id, phase, methodElt.getSimpleName().toString(), parameterTypes, parameterCardinalities, parameterNames);
            this.methods.put(origin, method);
            this.modified = true;
            break;
        }
    }
}

