/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.juzu.Action;
import org.juzu.Application;
import org.juzu.Path;
import org.juzu.Resource;
import org.juzu.View;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.meta.ApplicationMetaModel;
import org.juzu.impl.model.meta.ControllerMetaModel;
import org.juzu.impl.model.meta.MetaModelEvent;
import org.juzu.impl.model.meta.MethodMetaModel;
import org.juzu.impl.model.meta.TemplateMetaModel;
import org.juzu.impl.model.meta.TemplateRefMetaModel;
import org.juzu.impl.model.processor.ModelHandler;
import org.juzu.impl.model.processor.ProcessingContext;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.JSON;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.QN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModel
extends ModelHandler {
    LinkedHashMap<ElementHandle.Class, ControllerMetaModel> controllers = new LinkedHashMap();
    LinkedHashMap<ElementHandle.Field, TemplateRefMetaModel> templates = new LinkedHashMap();
    LinkedHashMap<ElementHandle.Package, ApplicationMetaModel> applications = new LinkedHashMap();
    ProcessingContext env;
    private final LinkedList<MetaModelEvent> queue = new LinkedList();
    private Logger log;

    public JSON toJSON() {
        JSON json = new JSON();
        json.add("templates", this.templates.values());
        json.add("applications", this.applications.values());
        json.add("controllers", this.controllers.values());
        return json;
    }

    public ApplicationMetaModel addApplication(String packageName, String applicationName) {
        return this.addApplication(ElementHandle.Package.create(new QN(packageName)), applicationName, null, null);
    }

    public TemplateRefMetaModel addTemplateRef(String className, String fieldName, String path) {
        return this.addTemplateRef(ElementHandle.Field.create(new FQN(className), fieldName), path);
    }

    public ControllerMetaModel addController(String className) {
        return this.addController(ElementHandle.Class.create(new FQN(className)));
    }

    public Collection<ApplicationMetaModel> getApplications() {
        return new ArrayList<ApplicationMetaModel>(this.applications.values());
    }

    public ApplicationMetaModel getApplication(ElementHandle.Package handle) {
        return this.applications.get(handle);
    }

    public ApplicationMetaModel addApplication(ElementHandle.Package handle, String applicationName, String defaultController, Boolean escapeXML) {
        if (this.applications.containsKey(handle)) {
            throw new IllegalStateException("Contains already application " + handle);
        }
        ApplicationMetaModel application = new ApplicationMetaModel(this, handle, applicationName, defaultController, escapeXML);
        this.applications.put(handle, application);
        this.queue(new MetaModelEvent(0, application));
        return application;
    }

    private TemplateRefMetaModel addTemplateRef(ElementHandle.Field handle, String path) {
        if (this.templates.containsKey(handle)) {
            throw new IllegalStateException();
        }
        TemplateRefMetaModel ref = new TemplateRefMetaModel(handle, path);
        this.templates.put(handle, ref);
        return ref;
    }

    private ControllerMetaModel addController(ElementHandle.Class handle) {
        if (this.controllers.containsKey(handle)) {
            throw new IllegalStateException();
        }
        ControllerMetaModel controller = new ControllerMetaModel(this, handle);
        this.controllers.put(handle, controller);
        return controller;
    }

    @Override
    public void postActivate(ProcessingContext env) {
        this.env = env;
        this.log = BaseProcessor.getLogger(MetaModel.class);
        this.gcApplications();
        this.gcControllers();
        this.gcTemplateRefs();
    }

    @Override
    public void processControllerMethod(ExecutableElement methodElt, String annotationName, Map<String, Object> annotationValues) throws CompilationException {
        TypeElement controllerElt = (TypeElement)methodElt.getEnclosingElement();
        ElementHandle.Class handle = ElementHandle.Class.create(controllerElt);
        ControllerMetaModel controller = this.controllers.get(handle);
        if (controller == null) {
            controller = this.addController(handle);
        }
        controller.addMethod(methodElt, annotationName, annotationValues);
    }

    @Override
    public void processDeclarationTemplate(VariableElement variableElt, String annotationName, Map<String, Object> annotationValues) throws CompilationException {
        String path = (String)annotationValues.get("value");
        ElementHandle.Field handle = ElementHandle.Field.create(variableElt);
        TemplateRefMetaModel ref = this.templates.get(handle);
        if (ref == null) {
            this.addTemplateRef(handle, path);
        } else if (!ref.path.equals(path)) {
            if (ref.template != null) {
                if (ref.template.refs.remove(ref.handle) == null) {
                    throw new AssertionError();
                }
                ref.template = null;
            }
            ref.path = path;
        }
    }

    @Override
    public void processApplication(PackageElement packageElt, String annotationName, Map<String, Object> annotationValues) throws CompilationException {
        ElementHandle.Package handle;
        ApplicationMetaModel application;
        TypeMirror defaultControllerElt = (TypeMirror)annotationValues.get("defaultController");
        String defaultController = defaultControllerElt != null ? ((Object)defaultControllerElt).toString() : null;
        Boolean escapeXML = (Boolean)annotationValues.get("escapeXML");
        String name = (String)annotationValues.get("name");
        if (name == null) {
            String s = packageElt.getSimpleName().toString();
            name = Character.toUpperCase(s.charAt(0)) + s.substring(1) + "Application";
        }
        if ((application = this.applications.get(handle = ElementHandle.Package.create(packageElt))) == null) {
            this.addApplication(handle, name, defaultController, escapeXML);
        } else {
            application.modified = true;
        }
    }

    @Override
    public void postProcess() {
        this.resolveTemplateRefs();
        this.resolveControllers();
        this.resolveApplications();
    }

    @Override
    public void prePassivate() {
        this.gcTemplates();
        this.env = null;
        this.log = null;
    }

    private void resolveApplications() {
        for (ApplicationMetaModel application : this.applications.values()) {
            if (!application.modified) continue;
            this.queue(new MetaModelEvent(2, application));
            application.modified = false;
        }
    }

    private void resolveControllers() {
        for (ControllerMetaModel controller : this.controllers.values()) {
            if (controller.application == null) {
                PackageElement packageElt = this.env.getPackageOf(this.env.get(controller.handle));
                QN packageQN = new QN(packageElt.getQualifiedName());
                for (ApplicationMetaModel application : this.applications.values()) {
                    if (!application.fqn.getPackageName().isPrefix(packageQN)) continue;
                    application.addController(controller);
                    controller.modified = false;
                }
                continue;
            }
            if (!controller.modified) continue;
            this.queue(new MetaModelEvent(2, controller));
            controller.modified = false;
        }
    }

    private void resolveTemplateRefs() {
        for (TemplateRefMetaModel ref : this.templates.values()) {
            if (ref.template != null) continue;
            VariableElement variableElt = this.env.get(ref.handle);
            PackageElement packageElt = this.env.getPackageOf(variableElt);
            QN packageQN = new QN(packageElt.getQualifiedName());
            for (ApplicationMetaModel application : this.applications.values()) {
                if (!application.fqn.getPackageName().isPrefix(packageQN)) continue;
                TemplateMetaModel template = application.templates.get(ref.path);
                if (template == null) {
                    template = application.addTemplate(ref);
                }
                template.addRef(ref);
            }
        }
    }

    private void gcApplications() {
        Iterator<ApplicationMetaModel> i = this.applications.values().iterator();
        while (i.hasNext()) {
            AnnotationMirror annotationMirror;
            ApplicationMetaModel application = i.next();
            PackageElement packageElt = this.env.get(application.handle);
            if (packageElt == null) {
                throw new UnsupportedOperationException();
            }
            boolean found = false;
            Iterator<Object> i$ = packageElt.getAnnotationMirrors().iterator();
            while (i$.hasNext() && !(found = ((TypeElement)(annotationMirror = i$.next()).getAnnotationType().asElement()).getQualifiedName().contentEquals(Application.class.getName()))) {
            }
            if (found) continue;
            application.model.queue(new MetaModelEvent(1, application));
            for (ControllerMetaModel controller : application.getControllers()) {
                application.removeController(controller);
            }
            for (TemplateMetaModel template : application.getTemplates()) {
                application.removeTemplate(template);
            }
            i.remove();
        }
    }

    private void gcControllers() {
        Iterator<ControllerMetaModel> i = this.controllers.values().iterator();
        while (i.hasNext()) {
            ControllerMetaModel controller = i.next();
            Iterator<MethodMetaModel> j = controller.methods.values().iterator();
            while (j.hasNext()) {
                MethodMetaModel method = j.next();
                ExecutableElement methodElt = this.env.get(method.handle);
                boolean remove = methodElt == null || methodElt.getAnnotation(View.class) == null && methodElt.getAnnotation(Action.class) == null && methodElt.getAnnotation(Resource.class) == null;
                if (!remove) continue;
                j.remove();
            }
            if (!controller.methods.isEmpty()) continue;
            if (controller.application != null) {
                controller.application.removeController(controller);
            }
            i.remove();
        }
    }

    private void gcTemplateRefs() {
        Iterator<TemplateRefMetaModel> i = this.templates.values().iterator();
        while (i.hasNext()) {
            TemplateRefMetaModel ref = i.next();
            VariableElement fieldElt = this.env.get(ref.handle);
            boolean remove = false;
            if (fieldElt == null) {
                this.log.log("Removing handle " + ref.handle + " that does not exist anymore");
                remove = true;
            } else if (fieldElt.getAnnotation(Path.class) == null) {
                this.log.log("Removing handle " + ref.handle + " that is not annoated anymore");
                remove = true;
            }
            if (!remove) continue;
            if (ref.template != null) {
                ref.template.removeRef(ref);
            }
            i.remove();
        }
    }

    private void gcTemplates() {
        for (ApplicationMetaModel application : this.applications.values()) {
            for (TemplateMetaModel template : application.getTemplates()) {
                if (!template.refs.isEmpty()) continue;
                application.removeTemplate(template);
            }
        }
    }

    void queue(MetaModelEvent event) {
        if (this.log != null) {
            this.log.log("Queue event " + event.getType() + " " + event.getObject());
        }
        this.queue.add(event);
    }

    public List<MetaModelEvent> popEvents() {
        ArrayList<MetaModelEvent> copy = new ArrayList<MetaModelEvent>(this.queue);
        this.queue.clear();
        return copy;
    }

    public MetaModelEvent popEvent() {
        return this.queue.isEmpty() ? null : this.queue.removeFirst();
    }

    public boolean hasEvents() {
        return !this.queue.isEmpty();
    }
}

