/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.ram;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.spi.fs.ram.RAMDir;
import org.juzu.impl.spi.fs.ram.RAMFile;
import org.juzu.impl.spi.fs.ram.RAMPath;
import org.juzu.impl.spi.fs.ram.RAMURLStreamHandler;
import org.juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMFileSystem
extends ReadWriteFileSystem<RAMPath> {
    private final RAMDir root = new RAMDir();
    private final URL contextURL = new URL("juzu", null, 0, "/", new RAMURLStreamHandler(this));

    @Override
    public RAMDir addDir(RAMPath parent, String name) throws IOException {
        return parent.addDir(name);
    }

    @Override
    public RAMFile addFile(RAMPath parent, String name) throws IOException {
        return parent.addFile(name);
    }

    @Override
    public void setContent(RAMPath file, Content content) throws IOException {
        file.update(content);
    }

    @Override
    public boolean equals(RAMPath left, RAMPath right) {
        return left == right;
    }

    @Override
    public RAMDir getRoot() throws IOException {
        return this.root;
    }

    @Override
    public RAMDir getParent(RAMPath path) throws IOException {
        return path.getParent();
    }

    @Override
    public String getName(RAMPath path) throws IOException {
        return path.getName();
    }

    @Override
    public Iterator<RAMPath> getChildren(RAMPath dir) throws IOException {
        return dir.getChildren().iterator();
    }

    @Override
    public RAMPath getChild(RAMPath dir, String name) throws IOException {
        return ((RAMDir)dir).children.get(name);
    }

    @Override
    public boolean isDir(RAMPath path) throws IOException {
        return path instanceof RAMDir;
    }

    @Override
    public boolean isFile(RAMPath path) throws IOException {
        return path instanceof RAMFile;
    }

    @Override
    public Content getContent(RAMPath file) throws IOException {
        return ((RAMFile)file).getContent();
    }

    @Override
    public long getLastModified(RAMPath path) throws IOException {
        return path.getLastModified();
    }

    @Override
    public URL getURL(RAMPath path) throws IOException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        StringBuilder sb = new StringBuilder();
        this.pathOf(path, '/', sb);
        String spec = sb.toString();
        return new URL(this.contextURL, spec);
    }

    @Override
    public File getFile(RAMPath path) throws IOException {
        return null;
    }
}

