/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.template.compiler;

import java.io.IOException;
import java.util.List;
import org.juzu.impl.spi.template.TemplateEmitter;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.compiler.CompilationPhase;
import org.juzu.impl.template.compiler.EmitContext;
import org.juzu.impl.template.compiler.EmitterContext;
import org.juzu.impl.utils.MethodInvocation;
import org.juzu.template.TagHandler;
import org.juzu.text.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmitPhase
extends CompilationPhase {
    private final EmitContext context;

    public EmitPhase(EmitContext context) {
        this.context = context;
    }

    public void emit(TemplateEmitter generator, ASTNode<?> node) throws IOException {
        this.doAttribute(node);
        this.doEmit(new EmitterContext(generator), node.getChildren());
        this.doUnattribute(node);
    }

    private void doEmit(EmitterContext ctx, List<ASTNode.Block<?>> blocks) throws IOException {
        for (ASTNode.Block<?> block : blocks) {
            if (block instanceof ASTNode.Section) {
                String chunk;
                int to;
                ASTNode.Section section = (ASTNode.Section)block;
                ctx.begin(section.getType(), section.getBeginPosition());
                int lineNumber = section.getBegin().getPosition().getLine();
                int colNumber = section.getBegin().getPosition().getCol();
                String text = section.getText();
                int from = 0;
                while ((to = text.indexOf(10, from)) != -1) {
                    chunk = text.substring(from, to);
                    ctx.appendText(chunk);
                    ctx.appendLineBreak(new Location(colNumber + (to - from), lineNumber));
                    from = to + 1;
                    ++lineNumber;
                    colNumber = 1;
                }
                chunk = text.substring(from);
                ctx.appendText(chunk);
                ctx.end();
                continue;
            }
            if (block instanceof ASTNode.URL) {
                ASTNode.URL url = (ASTNode.URL)block;
                MethodInvocation mi = this.context.resolveMethodInvocation(url.getTypeName(), url.getMethodName(), url.getArgs());
                if (mi == null) {
                    throw new UnsupportedOperationException("handle me gracefully");
                }
                ctx.writer.url(mi.getClassName(), mi.getMethodName(), mi.getMethodArguments());
                continue;
            }
            if (block instanceof ASTNode.Tag) {
                ASTNode.Tag tag = (ASTNode.Tag)block;
                TagHandler handler = this.get(tag);
                String className = handler.getClass().getName();
                if (tag.getChildren() != null) {
                    ctx.writer.openTag(className, tag.getArgs());
                    this.doEmit(ctx, tag.getChildren());
                    ctx.writer.closeTag(className, tag.getArgs());
                    continue;
                }
                ctx.writer.tag(className, tag.getArgs());
                continue;
            }
            throw new AssertionError();
        }
    }
}

