/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSON {
    private static final ScriptEngine engine;
    private static final Set<Class<?>> simpleTypes;
    private final TreeMap<String, Object> entries = new TreeMap();

    public Set<String> names() {
        return this.entries.keySet();
    }

    public Object get(String name) {
        return this.entries.get(name);
    }

    public String getString(String name) {
        return (String)this.entries.get(name);
    }

    public List<?> getList(String name) {
        return (List)this.entries.get(name);
    }

    public <E> List<? extends E> getList(String name, Class<E> elementType) {
        List entry = (List)this.entries.get(name);
        int len = entry != null ? entry.size() : 0;
        for (int i = 0; i < len; ++i) {
            Object obj = entry.get(i);
            if (elementType.isInstance(obj)) continue;
            throw new ClassCastException("Cannot cast " + obj + " to class " + elementType.getName());
        }
        return entry;
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.entries.get(name);
    }

    public JSON getJSON(String name) {
        return (JSON)this.entries.get(name);
    }

    public boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    public JSON clear() {
        this.entries.clear();
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JSON) {
            JSON that = (JSON)obj;
            return this.entries.equals(that.entries);
        }
        return false;
    }

    public <E> JSON add(Map<String, E> map) {
        for (Map.Entry<String, E> entry : map.entrySet()) {
            this.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public <E> JSON add(String name, Map<String, E> map) {
        this.entries.put(name, new JSON().add(map));
        return this;
    }

    public <E> JSON add(String name, E ... elements) {
        this.add(name, (Object)elements);
        return this;
    }

    public <E> JSON add(String name, Iterable<E> elements) {
        ArrayList<Object> r = new ArrayList<Object>();
        for (E element : elements) {
            r.add(this.unwrap(element));
        }
        this.entries.put(name, r);
        return this;
    }

    public JSON add(String name, Object json) {
        this.entries.put(name, this.unwrap(json));
        return this;
    }

    public TreeMap<String, Object> build() {
        TreeMap<String, Object> ret = new TreeMap<String, Object>((SortedMap<String, Object>)this.entries);
        for (Map.Entry<String, Object> entry : ret.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof JSON)) continue;
            JSON json = (JSON)value;
            entry.setValue(json.build());
        }
        return ret;
    }

    private Object unwrap(Object o) {
        Class<?> type;
        if (o != null && !(o instanceof JSON) && !simpleTypes.contains(type = o.getClass())) {
            if (o instanceof Iterable) {
                ArrayList<Object> r = new ArrayList<Object>();
                for (Object element : (Iterable)o) {
                    Object unwrapped = this.unwrap(element);
                    r.add(unwrapped);
                }
                o = r;
            } else if (o.getClass().isArray()) {
                int length = Array.getLength(o);
                ArrayList<Object> r = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object component = Array.get(o, i);
                    Object unwrapped = this.unwrap(component);
                    r.add(unwrapped);
                }
                o = r;
            } else {
                Object json;
                block14: {
                    json = null;
                    try {
                        Method toJSON = type.getMethod("toJSON", new Class[0]);
                        if (toJSON.getReturnType() == Void.TYPE) break block14;
                        try {
                            json = toJSON.invoke(o, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable t = e.getCause();
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (t instanceof Error) {
                                throw (Error)t;
                            }
                            throw new UndeclaredThrowableException(t);
                        }
                    }
                    catch (NoSuchMethodException ignore) {
                        // empty catch block
                    }
                }
                o = json != null ? this.unwrap(json) : o.toString();
            }
        }
        return o;
    }

    public <A extends Appendable> A toString(A appendable) throws IOException {
        return JSON.toString(this, appendable);
    }

    public <A extends Appendable> A toString(A appendable, int indent) throws IOException {
        return JSON.toString(this, appendable, indent);
    }

    public String toString() {
        try {
            return this.toString(new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static <A extends Appendable> A toString(Object o, A appendable) throws IOException {
        return JSON.toString(o, appendable, 0);
    }

    public static <A extends Appendable> A toString(Object o, A appendable, int indent) throws IOException {
        return JSON.toString(o, appendable, 0, indent);
    }

    private static <A extends Appendable> A toString(Object o, A appendable, int margin, int indent) throws IOException {
        if (o == null) {
            appendable.append("null");
        } else if (o instanceof JSON) {
            JSON m = (JSON)o;
            appendable.append('{');
            Iterator<Map.Entry<String, Object>> iterator = m.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                if (indent > 0) {
                    appendable.append('\n');
                    JSON.pad(appendable, margin + indent);
                }
                appendable.append('\"');
                appendable.append(entry.getKey().toString());
                appendable.append("\":");
                JSON.toString(entry.getValue(), appendable, margin + indent, indent);
                if (iterator.hasNext()) {
                    appendable.append(',');
                    continue;
                }
                if (indent <= 0) continue;
                appendable.append('\n');
                JSON.pad(appendable, margin);
            }
            appendable.append('}');
        } else if (o instanceof List) {
            appendable.append('[');
            List list = (List)o;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object e = i.next();
                if (indent > 0) {
                    appendable.append('\n');
                    JSON.pad(appendable, margin + indent);
                }
                JSON.toString(e, appendable, margin + indent, indent);
                if (i.hasNext()) {
                    appendable.append(',');
                    continue;
                }
                if (indent <= 0) continue;
                appendable.append('\n');
                JSON.pad(appendable, margin);
            }
            appendable.append(']');
        } else if (o instanceof Boolean || o instanceof Number) {
            appendable.append(o.toString());
        } else {
            appendable.append('\"');
            CharSequence s = o instanceof CharSequence ? (CharSequence)o : o.toString();
            int len = s.length();
            block10: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        appendable.append("\\\"");
                        continue block10;
                    }
                    case '\n': {
                        appendable.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        appendable.append("\\r");
                        continue block10;
                    }
                    case '\b': {
                        appendable.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        appendable.append("\\f");
                        continue block10;
                    }
                    case '\t': {
                        appendable.append("\\t");
                        continue block10;
                    }
                    default: {
                        appendable.append(c);
                    }
                }
            }
            appendable.append('\"');
        }
        return appendable;
    }

    private static void pad(Appendable appendable, int size) throws IOException {
        while (size-- > 0) {
            appendable.append(' ');
        }
    }

    public static Object parse(String json) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            String eval = "var tmp = (" + json + ");var o = new java.util.concurrent.atomic.AtomicReference(tmp.toJava());";
            engine.eval(eval, (Bindings)bindings);
            AtomicReference ret = (AtomicReference)bindings.get("o");
            return ret.get();
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            String init = Tools.read(Tools.class.getResource("json.js"));
            ScriptEngine tmp = new ScriptEngineManager().getEngineByName("JavaScript");
            tmp.eval(init);
            engine = tmp;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        simpleTypes = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Boolean.class));
    }
}

