/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.juzu.impl.utils.JSON;
import org.juzu.impl.utils.Tools;
import org.juzu.metadata.ControllerDescriptor;
import org.juzu.metadata.ControllerMethod;
import org.juzu.metadata.TemplateDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor {
    private final Class<?> applicationClass;
    private final String packageName;
    private final String name;
    private Class<?> defaultController;
    private final Boolean escapeXML;
    private final List<ControllerDescriptor> controllers;
    private final List<ControllerMethod> controllerMethods;
    private final String templatesPackageName;
    private final List<TemplateDescriptor> templates;

    public ApplicationDescriptor(Class<?> applicationClass, Class<?> defaultController, Boolean escapeXML, String templatesPackageName) {
        JSON props;
        InputStream in = null;
        try {
            in = applicationClass.getResourceAsStream("config.json");
            String s = Tools.read(in);
            props = (JSON)JSON.parse(s);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            Tools.safeClose(in);
        }
        ArrayList<ControllerDescriptor> controllers = new ArrayList<ControllerDescriptor>();
        ArrayList<ControllerMethod> controllerMethods = new ArrayList<ControllerMethod>();
        ArrayList<TemplateDescriptor> templates = new ArrayList<TemplateDescriptor>();
        try {
            Field f;
            Class<?> clazz;
            for (String fqn : props.getList("controllers", String.class)) {
                clazz = applicationClass.getClassLoader().loadClass(fqn);
                f = clazz.getField("DESCRIPTOR");
                ControllerDescriptor controller = (ControllerDescriptor)f.get(null);
                controllers.add(controller);
                controllerMethods.addAll(controller.getMethods());
            }
            for (String fqn : props.getList("templates", String.class)) {
                clazz = applicationClass.getClassLoader().loadClass(fqn);
                f = clazz.getField("DESCRIPTOR");
                TemplateDescriptor descriptor = (TemplateDescriptor)f.get(null);
                templates.add(descriptor);
            }
        }
        catch (Exception e) {
            AssertionError ae = new AssertionError((Object)"Cannot load config");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        this.applicationClass = applicationClass;
        this.name = applicationClass.getSimpleName();
        this.packageName = applicationClass.getPackage().getName();
        this.templatesPackageName = templatesPackageName;
        this.defaultController = defaultController;
        this.escapeXML = escapeXML;
        this.controllers = controllers;
        this.controllerMethods = controllerMethods;
        this.templates = templates;
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public ClassLoader getApplicationLoader() {
        return this.applicationClass.getClassLoader();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Boolean getEscapeXML() {
        return this.escapeXML;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getDefaultController() {
        return this.defaultController;
    }

    public List<ControllerDescriptor> getControllers() {
        return this.controllers;
    }

    public List<ControllerMethod> getControllerMethods() {
        return this.controllerMethods;
    }

    public List<TemplateDescriptor> getTemplates() {
        return this.templates;
    }

    public TemplateDescriptor getTemplate(String path) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        for (TemplateDescriptor template : this.templates) {
            if (!template.getPath().equals(path)) continue;
            return template;
        }
        return null;
    }

    public ControllerMethod getControllerMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        for (int i = 0; i < this.controllerMethods.size(); ++i) {
            Class<?>[] a;
            ControllerMethod cm = this.controllerMethods.get(i);
            Method m = cm.getMethod();
            if (!type.equals(cm.getType()) || !m.getName().equals(name) || (a = m.getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (a[j].equals(parameterTypes[j])) continue;
            }
            return cm;
        }
        return null;
    }

    public ControllerMethod getControllerMethodById(String methodId) {
        for (int i = 0; i < this.controllerMethods.size(); ++i) {
            ControllerMethod cm = this.controllerMethods.get(i);
            if (!cm.getId().equals(methodId)) continue;
            return cm;
        }
        return null;
    }

    public String getTemplatesPackageName() {
        return this.templatesPackageName;
    }
}

