/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.metadata;

import org.juzu.impl.utils.Tools;
import org.juzu.metadata.Cardinality;

public class ControllerParameter {
    private final String name;
    private final Cardinality cardinality;
    private final String value;

    public ControllerParameter(String name, Cardinality cardinality) throws NullPointerException {
        this(name, cardinality, null);
    }

    public ControllerParameter(String name, Cardinality cardinality, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null parameter name accepted");
        }
        if (cardinality == null) {
            throw new NullPointerException("No null parameter cardinality accepted");
        }
        this.name = name;
        this.cardinality = cardinality;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ControllerParameter) {
            ControllerParameter that = (ControllerParameter)obj;
            return this.name.equals(that.name) && Tools.safeEquals(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        return "ControllerParameter[name=" + this.name + ",value=" + this.value + "]";
    }
}

