/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.template;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.juzu.Response;
import org.juzu.UndeclaredIOException;
import org.juzu.impl.application.InternalApplicationContext;
import org.juzu.request.ApplicationContext;
import org.juzu.request.MimeContext;
import org.juzu.request.RequestContext;
import org.juzu.template.TemplateExecutionException;
import org.juzu.template.TemplateRenderContext;
import org.juzu.text.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Template {
    private final String path;
    private final ApplicationContext applicationContext;

    public Template(ApplicationContext applicationContext, String path) {
        this.applicationContext = applicationContext;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void render() throws TemplateExecutionException, UndeclaredIOException {
        this.render(Collections.emptyMap(), null);
    }

    public void render(Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.render(Collections.emptyMap(), locale);
    }

    public void render(Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.render(parameters, null);
    }

    public void render(Map<String, ?> parameters, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        try {
            RequestContext context = InternalApplicationContext.getCurrentRequest();
            if (!(context instanceof MimeContext)) {
                throw new AssertionError((Object)"does not make sense");
            }
            MimeContext mime = (MimeContext)context;
            Response.Mime stream = this.ok(parameters, locale);
            mime.setResponse(stream);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public void render(Printer printer) throws TemplateExecutionException, UndeclaredIOException {
        this.render(printer, Collections.emptyMap(), null);
    }

    public void render(Printer printer, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.render(printer, Collections.emptyMap(), locale);
    }

    public void render(Printer printer, Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.render(printer, parameters, null);
    }

    public final Response.Mime ok() {
        return this.ok(null, null);
    }

    public final Response.Mime ok(Locale locale) {
        return this.ok(null, locale);
    }

    public final Response.Mime ok(Map<String, ?> parameters) {
        return this.ok(parameters, null);
    }

    public final Response.Mime ok(Map<String, ?> parameters, Locale locale) {
        final TemplateRenderContext trc = this.applicationContext.render(this, parameters, locale);
        return new Response.Render(){

            public String getTitle() {
                return trc.getTitle();
            }

            public void send(Printer printer) throws IOException {
                trc.render(printer);
            }
        };
    }

    public final Response.Resource notFound() {
        return this.notFound(null, null);
    }

    public final Response.Resource notFound(Locale locale) {
        return this.notFound(null, locale);
    }

    public final Response.Resource notFound(Map<String, ?> parameters) {
        return this.notFound(parameters, null);
    }

    public final Response.Resource notFound(Map<String, ?> parameters, Locale locale) {
        final TemplateRenderContext trc = this.applicationContext.render(this, parameters, locale);
        return new Response.Resource(){

            public int getStatus() {
                return 404;
            }

            public void send(Printer printer) throws IOException {
                trc.render(printer);
            }
        };
    }

    public abstract Builder with();

    public Builder with(Locale locale) {
        Builder builder = this.with();
        builder.locale = locale;
        return builder;
    }

    public void render(Printer printer, Map<String, ?> attributes, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        if (printer == null) {
            throw new NullPointerException("No null printe provided");
        }
        try {
            TemplateRenderContext trc = this.applicationContext.render(this, attributes, locale);
            trc.render(printer);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[path=" + this.path + "]";
    }

    public class Builder {
        private Map<String, Object> parameters;
        private Locale locale;

        public final void render() {
            Template.this.render(this.parameters, this.locale);
        }

        public final Response.Stream ok() {
            return Template.this.ok(this.parameters, this.locale);
        }

        public final Response.Stream notFound() {
            return Template.this.notFound(this.parameters, this.locale);
        }

        public Builder set(String name, Object value) throws NullPointerException {
            if (name == null) {
                throw new NullPointerException("The parameter argument cannot be null");
            }
            if (value != null) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, Object>();
                }
                this.parameters.put(name, value);
            } else if (this.parameters != null) {
                this.parameters.remove(name);
            }
            return this;
        }
    }
}

