/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.juzu.impl.compiler.file.FileKey;
import org.juzu.impl.compiler.file.FileManager;
import org.juzu.impl.compiler.file.JavaFileObjectImpl;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VirtualFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    final FileManager<?> sourcePath;
    final FileManager<?> classOutput;
    final FileManager<?> classPath;
    final FileManager<?> sourceOutput;

    public VirtualFileManager(JavaFileManager fileManager, ReadFileSystem<?> sourcePath, ReadFileSystem<?> classPath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput) {
        super(fileManager);
        this.sourcePath = this.safeWrap(sourcePath);
        this.classPath = this.safeWrap(classPath);
        this.classOutput = this.safeWrap(classOutput);
        this.sourceOutput = this.safeWrap(sourceOutput);
    }

    private <P> FileManager<P> safeWrap(ReadFileSystem<P> fs) {
        return fs != null ? new FileManager<P>(fs) : null;
    }

    private FileManager<?> getFiles(JavaFileManager.Location location) {
        if (location instanceof StandardLocation) {
            switch ((StandardLocation)location) {
                case SOURCE_PATH: {
                    return this.sourcePath;
                }
                case SOURCE_OUTPUT: {
                    return this.sourceOutput;
                }
                case CLASS_OUTPUT: {
                    return this.classOutput;
                }
                case CLASS_PATH: {
                    return this.classPath;
                }
            }
        }
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> s = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> ret = null;
        FileManager<?> files = this.getFiles(location);
        if (files != null) {
            ret = new ArrayList<JavaFileObject>();
            files.list(packageName, kinds, recurse, (Collection<JavaFileObject>)ret);
        }
        if (ret == null) {
            return s;
        }
        for (JavaFileObject o : s) {
            ret.add(o);
        }
        return ret;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof JavaFileObjectImpl) {
            JavaFileObjectImpl fileClass = (JavaFileObjectImpl)file;
            return fileClass.getKey().fqn;
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileKey key = FileKey.newResourceName(packageName, relativeName);
        FileManager<?> files = this.getFiles(location);
        if (files != null) {
            return files.getReadable(key);
        }
        throw new FileNotFoundException("Cannot write: " + location);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        FileKey key = FileKey.newResourceName(packageName, relativeName);
        if (location == StandardLocation.SOURCE_PATH) {
            JavaFileObject file = this.sourcePath.getReadable(key);
            if (file == null) {
                throw new FileNotFoundException("Not found:" + key.toString());
            }
            return file;
        }
        FileManager<?> files = this.getFiles(location);
        if (files != null) {
            return files.getWritable(key);
        }
        throw new FileNotFoundException("Cannot write: " + location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        FileKey ka = ((JavaFileObjectImpl)a).getKey();
        FileKey kb = ((JavaFileObjectImpl)b).getKey();
        return ka.equals(kb);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        FileManager<?> files = this.getFiles(location);
        if (files != null) {
            FileKey key = FileKey.newJavaName(className, kind);
            return files.getWritable(key);
        }
        throw new UnsupportedOperationException("Location " + location + " not supported");
    }
}

