/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.processor;

import java.io.Serializable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public abstract class ElementHandle
implements Serializable {
    public static ElementHandle create(Element elt) {
        ElementKind kind = elt.getKind();
        switch (kind) {
            case FIELD: {
                VariableElement variableElt = (VariableElement)elt;
                TypeElement typeElt = (TypeElement)variableElt.getEnclosingElement();
                String name = variableElt.getSimpleName().toString();
                String fqn = typeElt.getQualifiedName().toString();
                return new Field(fqn, name);
            }
            case CLASS: {
                TypeElement typeElt = (TypeElement)elt;
                String fqn = typeElt.getQualifiedName().toString();
                return new Class(fqn);
            }
            case PACKAGE: {
                PackageElement packageElt = (PackageElement)elt;
                return new Package(packageElt.getQualifiedName().toString());
            }
        }
        throw new UnsupportedOperationException("Element " + elt + " with kind " + (Object)((Object)kind) + " not supported");
    }

    public abstract Element get(ProcessingEnvironment var1);

    private static class Field
    extends ElementHandle {
        private final String fqn;
        private final String fieldName;

        private Field(String fqn, String fieldName) {
            this.fqn = fqn;
            this.fieldName = fieldName;
        }

        public Element get(ProcessingEnvironment env) {
            TypeElement typeElt = env.getElementUtils().getTypeElement(this.fqn);
            for (VariableElement variableElt : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                if (!variableElt.getSimpleName().contentEquals(this.fieldName)) continue;
                return variableElt;
            }
            return null;
        }
    }

    private static class Class
    extends ElementHandle {
        private final String fqn;

        private Class(String fqn) {
            this.fqn = fqn;
        }

        public Element get(ProcessingEnvironment env) {
            return env.getElementUtils().getTypeElement(this.fqn);
        }
    }

    private static class Package
    extends ElementHandle {
        private final String fqn;

        private Package(String fqn) {
            this.fqn = fqn;
        }

        public Element get(ProcessingEnvironment env) {
            return env.getElementUtils().getPackageElement(this.fqn);
        }
    }
}

