/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.io.Serializable;

public class FQN
implements Serializable {
    private final String fullName;
    private final String packageName;
    private final String simpleName;

    public FQN(String fullName) {
        String simpleName;
        String packageName;
        int pos = fullName.lastIndexOf(46);
        if (pos == -1) {
            packageName = "";
            simpleName = fullName;
        } else {
            packageName = fullName.substring(0, pos);
            simpleName = fullName.substring(pos + 1);
        }
        this.fullName = fullName;
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public FQN(String packageName, String simpleName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.fullName = packageName.isEmpty() ? simpleName : packageName + "." + simpleName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String toString() {
        return this.fullName;
    }
}

