/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageMap<V> {
    private ArrayList<String> entriesNames = new ArrayList();
    private ArrayList<V> entriesValues = new ArrayList();

    public int getSize() {
        return this.entriesNames.size();
    }

    public String getName(int index) throws IndexOutOfBoundsException {
        return this.entriesNames.get(index);
    }

    public V getValue(int index) throws IndexOutOfBoundsException {
        return this.entriesValues.get(index);
    }

    public V putValue(String packageName, V value) throws NullPointerException {
        if (packageName == null) {
            throw new NullPointerException("No null package name accepted");
        }
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        int size = this.entriesNames.size();
        for (int i = 0; i < size; ++i) {
            String entryName = this.entriesNames.get(i);
            if (!packageName.equals(entryName)) continue;
            V previous = this.entriesValues.get(i);
            this.entriesValues.set(i, value);
            return previous;
        }
        this.entriesNames.add(packageName);
        this.entriesValues.add(value);
        return null;
    }

    public V getValue(String packageName) throws NullPointerException {
        if (packageName == null) {
            throw new NullPointerException("No null package name accepted");
        }
        int size = this.entriesNames.size();
        for (int i = 0; i < size; ++i) {
            String entryName = this.entriesNames.get(i);
            if (!packageName.equals(entryName)) continue;
            return this.entriesValues.get(i);
        }
        return null;
    }

    public V resolveValue(String packageName) throws NullPointerException {
        if (packageName == null) {
            throw new NullPointerException("No null package name accepted");
        }
        int matchLength = 0;
        int matchIndex = -1;
        int size = this.entriesNames.size();
        for (int i = 0; i < size; ++i) {
            String entryName = this.entriesNames.get(i);
            if (packageName.equals(entryName)) {
                matchLength = entryName.length();
                matchIndex = i;
                break;
            }
            if (matchLength == 0 && entryName.length() == 0) {
                matchLength = 0;
                matchIndex = i;
                continue;
            }
            if (entryName.length() <= matchLength || packageName.length() <= entryName.length() + 1 || packageName.charAt(entryName.length()) != '.' || !packageName.startsWith(entryName)) continue;
            matchLength = entryName.length();
            matchIndex = i;
        }
        return matchIndex != -1 ? (V)this.entriesValues.get(matchIndex) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PackageMap[");
        int size = this.entriesNames.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.entriesNames.get(i));
            sb.append('=');
            sb.append(this.entriesValues.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

