/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.disk;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.test.AbstractTestCase;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskFileSystemTestCase
extends AbstractTestCase {
    @Test
    public void testFoo() throws Exception {
        File root = new File(System.getProperty("test.resources"));
        DiskFileSystemTestCase.assertNotNull((Object)root);
        DiskFileSystemTestCase.assertNotNull((Object)root.isDirectory());
        this.doTest((ReadFileSystem)new DiskFileSystem(root, new String[]{"compiler", "disk"}), (Object)root);
    }

    private <P> void doTest(ReadFileSystem<P> fs, P root) throws IOException {
        DiskFileSystemTestCase.assertEquals(root, (Object)fs.getRoot());
        DiskFileSystemTestCase.assertTrue((boolean)fs.isDir(root));
        DiskFileSystemTestCase.assertFalse((boolean)fs.isFile(root));
        DiskFileSystemTestCase.assertEquals((String)"", (String)fs.getName(root));
        DiskFileSystemTestCase.assertEquals(null, (Object)fs.getParent(root));
        Iterator rootChildren = fs.getChildren(root);
        DiskFileSystemTestCase.assertTrue((boolean)rootChildren.hasNext());
        Object compiler = rootChildren.next();
        DiskFileSystemTestCase.assertFalse((boolean)rootChildren.hasNext());
        DiskFileSystemTestCase.assertTrue((boolean)fs.isDir(compiler));
        DiskFileSystemTestCase.assertFalse((boolean)fs.isFile(compiler));
        DiskFileSystemTestCase.assertEquals((String)"compiler", (String)fs.getName(compiler));
        DiskFileSystemTestCase.assertEquals(root, (Object)fs.getParent(compiler));
        Iterator compilerChildren = fs.getChildren(compiler);
        DiskFileSystemTestCase.assertTrue((boolean)compilerChildren.hasNext());
        Object disk = compilerChildren.next();
        DiskFileSystemTestCase.assertFalse((boolean)compilerChildren.hasNext());
        DiskFileSystemTestCase.assertTrue((boolean)fs.isDir(disk));
        DiskFileSystemTestCase.assertFalse((boolean)fs.isFile(disk));
        DiskFileSystemTestCase.assertEquals((String)"disk", (String)fs.getName(disk));
        DiskFileSystemTestCase.assertEquals(compiler, (Object)fs.getParent(disk));
        Iterator diskChildren = fs.getChildren(disk);
        DiskFileSystemTestCase.assertTrue((boolean)diskChildren.hasNext());
        Object a = diskChildren.next();
        DiskFileSystemTestCase.assertFalse((boolean)diskChildren.hasNext());
        DiskFileSystemTestCase.assertFalse((boolean)fs.isDir(a));
        DiskFileSystemTestCase.assertTrue((boolean)fs.isFile(a));
        DiskFileSystemTestCase.assertEquals((String)"A.java", (String)fs.getName(a));
        DiskFileSystemTestCase.assertEquals(disk, (Object)fs.getParent(a));
    }
}

