/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaModelProcessor
extends BaseProcessor {
    public static final MessageCode ANNOTATION_UNSUPPORTED = new MessageCode("ANNOTATION_UNSUPPORTED", "The annotation of this element cannot be supported");
    private MetaModel metaModel;
    private Set<TypeElement> annotations;
    private int index;
    private final Logger log = BaseProcessor.getLogger(this.getClass());
    private List<MetaModelPlugin> plugins;

    @Override
    protected void doInit(ProcessingContext context) {
        this.log.log("Using processing env " + context.getClass().getName());
        ArrayList<MetaModelPlugin> metaModelPlugins = Tools.list(ServiceLoader.load(MetaModelPlugin.class, MetaModelPlugin.class.getClassLoader()));
        StringBuilder msg = new StringBuilder("Using plugins:");
        for (MetaModelPlugin plugin : metaModelPlugins) {
            msg.append(" ").append(plugin.getName());
        }
        this.log.log(msg);
        HashSet<TypeElement> supportedAnnotationTypes = new HashSet<TypeElement>();
        for (MetaModelPlugin plugin : metaModelPlugins) {
            for (Class<? extends Annotation> type : plugin.getAnnotationTypes()) {
                TypeElement supportedAnnotationType = context.getTypeElement(type.getName());
                supportedAnnotationTypes.add(supportedAnnotationType);
            }
        }
        this.annotations = supportedAnnotationTypes;
        this.index = 0;
        this.plugins = metaModelPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block15: {
            if (!roundEnv.errorRaised()) {
                if (roundEnv.processingOver()) {
                    this.log.log("APT processing over");
                    this.log.log("Passivating model");
                    this.metaModel.prePassivate();
                    ObjectOutputStream out = null;
                    try {
                        FileObject file = this.getContext().createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "metamodel.ser", new Element[0]);
                        out = new ObjectOutputStream(file.openOutputStream());
                        out.writeObject(this.metaModel);
                        this.metaModel = null;
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        Tools.safeClose(out);
                        throw throwable;
                    }
                    Tools.safeClose(out);
                    {
                        break block15;
                        catch (IOException e) {
                            this.log.log("Could not passivate model ", e);
                            Object var6_10 = null;
                            Tools.safeClose(out);
                            break block15;
                        }
                    }
                }
                this.log.log("Starting APT round #" + this.index);
                if (this.metaModel == null) {
                    block16: {
                        Object var9_15;
                        InputStream in = null;
                        try {
                            FileObject file = this.getContext().getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "metamodel.ser");
                            in = file.openInputStream();
                            ObjectInputStream ois = new ObjectInputStream(in);
                            this.metaModel = (MetaModel)ois.readObject();
                            this.log.log("Loaded model from " + file.toUri());
                            var9_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_16 = null;
                            Tools.safeClose(in);
                            throw throwable;
                        }
                        Tools.safeClose(in);
                        {
                            break block16;
                            catch (Exception e) {
                                this.log.log("Created new meta model");
                                MetaModel metaModel = new MetaModel();
                                this.log.log("Adding meta model plugins");
                                for (MetaModelPlugin plugin : this.plugins) {
                                    this.log.log("Adding meta model plugin: " + plugin.getName());
                                    metaModel.addPlugin(plugin.getName(), plugin);
                                }
                                this.metaModel = metaModel;
                                var9_15 = null;
                                Tools.safeClose(in);
                            }
                        }
                    }
                    this.log.log("Activating model");
                    this.metaModel.postActivate(this.getContext());
                }
                for (TypeElement annotationElt : this.annotations) {
                    for (Element annotatedElt : roundEnv.getElementsAnnotatedWith(annotationElt)) {
                        if (annotatedElt.getAnnotation(Generated.class) != null) continue;
                        for (AnnotationMirror annotationMirror : annotatedElt.getAnnotationMirrors()) {
                            if (!((Object)annotationMirror.getAnnotationType().asElement()).equals(annotationElt)) continue;
                            AnnotationData annotationData = AnnotationData.create(annotationMirror);
                            String annotationFQN = annotationElt.getQualifiedName().toString();
                            this.metaModel.processAnnotation(annotatedElt, annotationFQN, annotationData);
                        }
                    }
                }
                this.log.log("Post processing model");
                this.metaModel.postProcessAnnotations();
                this.log.log("Ending APT round #" + this.index++);
            }
        }
    }
}

