/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.ajax;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyMap;
import juzu.Response;
import juzu.asset.Asset;
import juzu.asset.AssetLocation;
import juzu.asset.AssetType;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.application.ApplicationException;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.asset.Manager;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.plugin.Plugin;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.plugin.ajax.Ajax;
import juzu.request.RenderContext;

public class AjaxPlugin
extends Plugin
implements RequestFilter {
    Map<String, ControllerMethod> table;
    @Inject
    ApplicationDescriptor desc;
    @Inject
    @Manager(value=AssetType.SCRIPT)
    AssetManager manager;

    public AjaxPlugin() {
        super("ajax");
    }

    @PostConstruct
    public void start() {
        this.manager.addAsset(new AssetMetaData("juzu.ajax", AssetLocation.CLASSPATH, "/juzu/impl/plugin/ajax/script.js", "jquery"));
        HashMap<String, ControllerMethod> table = new HashMap<String, ControllerMethod>();
        for (ControllerMethod cm : this.desc.getController().getMethods()) {
            Ajax ajax = cm.getMethod().getAnnotation(Ajax.class);
            if (ajax == null) continue;
            table.put(cm.getName(), cm);
        }
        this.table = table;
    }

    public void invoke(final Request request) throws ApplicationException {
        Response response;
        request.invoke();
        if (request.getContext() instanceof RenderContext && (response = request.getResponse()) instanceof Response.Render) {
            Response.Render render = (Response.Render)response;
            PropertyMap properties = new PropertyMap(response.getProperties());
            properties.addValues(Response.Render.SCRIPT, Asset.ref("juzu.ajax"));
            final Streamable decorated = render.getStreamable();
            Streamable<Stream.Char> decorator = new Streamable<Stream.Char>(){

                @Override
                public void send(Stream.Char stream) throws IOException {
                    stream.append("<div class=\"jz\">\n");
                    for (Map.Entry<String, ControllerMethod> entry : AjaxPlugin.this.table.entrySet()) {
                        String baseURL = ((RenderContext)request.getContext()).createURLBuilder(entry.getValue()).toString();
                        stream.append("<div data-method-id=\"");
                        stream.append(entry.getValue().getId());
                        stream.append("\" data-url=\"");
                        stream.append(baseURL);
                        stream.append("\"/>");
                        stream.append("</div>");
                    }
                    decorated.send(stream);
                    stream.append("</div>");
                }
            };
            request.setResponse(new Response.Render(properties, decorator));
        }
    }
}

