/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import java.net.URL;
import java.net.URLClassLoader;
import juzu.Scope;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.inject.Export;
import juzu.impl.inject.spi.AbstractInjectManagerTestCase;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.test.CompilerAssert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIManagerTestCase<B, I>
extends AbstractInjectManagerTestCase<B, I> {
    public CDIManagerTestCase(InjectImplementation di) {
        super(di);
    }

    @Test
    public void testExport() throws Exception {
        if (this.di == InjectImplementation.CDI_WELD) {
            RAMFileSystem sources = new RAMFileSystem();
            RAMFileSystem classes = new RAMFileSystem();
            RAMDir foo = sources.addDir((RAMPath)sources.getRoot(), "foo");
            foo.addFile("Bean1.java").update("package foo; public class Bean1 {}");
            foo.addFile("Bean2.java").update("package foo; @" + Export.class.getName() + " public class Bean2 {}");
            foo.addFile("Bean3.java").update("package foo; @" + Export.class.getName() + " public class Bean3 {}");
            foo.addFile("Bean4.java").update("package foo; @" + Export.class.getName() + " public class Bean4 {}");
            CompilerAssert helper = new CompilerAssert(sources, classes);
            helper.assertCompile();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{classes.getURL()}, Thread.currentThread().getContextClassLoader());
            Class<?> bean1Class = classLoader.loadClass("foo.Bean1");
            Class<?> bean2Class = classLoader.loadClass("foo.Bean2");
            Class<?> bean3Class = classLoader.loadClass("foo.Bean3");
            Class<?> bean4Class = classLoader.loadClass("foo.Bean4");
            this.init((ReadFileSystem<?>)classes, classLoader);
            this.bootstrap.declareBean(bean2Class, null, null, null);
            this.bootstrap.bindBean(bean3Class, null, bean3Class.newInstance());
            this.boot(new Scope[0]);
            Object bean1 = this.mgr.resolveBean(bean1Class);
            CDIManagerTestCase.assertNotNull((Object)bean1);
            Object bean2 = this.mgr.resolveBean(bean2Class);
            CDIManagerTestCase.assertNotNull((Object)bean2);
            Object bean3 = this.mgr.resolveBean(bean3Class);
            CDIManagerTestCase.assertNotNull((Object)bean3);
            Object bean4 = this.mgr.resolveBean(bean4Class);
            CDIManagerTestCase.assertNull((Object)bean4);
        }
    }
}

