/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.controller.descriptor.ControllerParameter;
import juzu.impl.utils.Cardinality;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class RenderMethodTestCase
extends AbstractTestCase {
    private Class<?> aClass;
    private ApplicationDescriptor descriptor;

    public void setUp() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("request", "method", "render");
        compiler.assertCompile();
        this.aClass = compiler.assertClass("request.method.render.A");
        compiler.assertClass("request.method.render.A_");
        Class<?> appClass = compiler.assertClass("request.method.render.RenderApplication");
        this.descriptor = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
    }

    @Test
    public void testNoArg() throws Exception {
        ControllerMethod cm = this.descriptor.getController().getMethod(this.aClass, "noArg", new Class[0]);
        RenderMethodTestCase.assertEquals((String)"noArg", (String)cm.getName());
        RenderMethodTestCase.assertEquals((Object)Phase.RENDER, (Object)cm.getPhase());
        RenderMethodTestCase.assertEquals(Collections.emptyList(), cm.getArguments());
    }

    @Test
    public void testStringArg() throws Exception {
        ControllerMethod cm = this.descriptor.getController().getMethod(this.aClass, "oneArg", new Class[]{String.class});
        RenderMethodTestCase.assertEquals((String)"oneArg", (String)cm.getName());
        RenderMethodTestCase.assertEquals((Object)Phase.RENDER, (Object)cm.getPhase());
        RenderMethodTestCase.assertEquals(Arrays.asList(new ControllerParameter("foo", Cardinality.SINGLE)), cm.getArguments());
    }
}

