/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.controller.descriptor.ControllerParameter;
import juzu.impl.utils.Cardinality;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ResourceMethodTestCase
extends AbstractTestCase {
    private Class<?> aClass;
    private ApplicationDescriptor descriptor;

    public void setUp() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("request", "method", "resource");
        compiler.assertCompile();
        this.aClass = compiler.assertClass("request.method.resource.A");
        compiler.assertClass("request.method.resource.A_");
        Class<?> appClass = compiler.assertClass("request.method.resource.ResourceApplication");
        this.descriptor = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
    }

    @Test
    public void testNoArg() throws Exception {
        ControllerMethod cm = this.descriptor.getController().getMethod(this.aClass, "noArg", new Class[0]);
        ResourceMethodTestCase.assertEquals((String)"noArg", (String)cm.getName());
        ResourceMethodTestCase.assertEquals((Object)Phase.RESOURCE, (Object)cm.getPhase());
        ResourceMethodTestCase.assertEquals(Collections.emptyList(), cm.getArguments());
    }

    @Test
    public void testStringArg() throws Exception {
        ControllerMethod cm = this.descriptor.getController().getMethod(this.aClass, "oneArg", new Class[]{String.class});
        ResourceMethodTestCase.assertEquals((String)"oneArg", (String)cm.getName());
        ResourceMethodTestCase.assertEquals((Object)Phase.RESOURCE, (Object)cm.getPhase());
        ResourceMethodTestCase.assertEquals(Arrays.asList(new ControllerParameter("foo", Cardinality.SINGLE)), cm.getArguments());
    }
}

