/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template;

import java.util.ConcurrentModificationException;
import javax.naming.AuthenticationException;
import juzu.impl.application.ApplicationException;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.template.TemplateExecutionException;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import org.junit.Test;

public class ThrowableTestCase
extends AbstractInjectTestCase {
    public ThrowableTestCase(InjectImplementation di) {
        super(di);
    }

    @Test
    public void testChecked() throws Exception {
        MockApplication<?> app = this.application("template", "throwable", "checked").init();
        MockClient client = app.client();
        try {
            client.render();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(AuthenticationException.class, ThrowableTestCase.assertInstanceOf(TemplateExecutionException.class, e.getCause()).getCause());
        }
    }

    @Test
    public void testRuntime() throws Exception {
        MockApplication<?> app = this.application("template", "throwable", "runtime").init();
        MockClient client = app.client();
        try {
            client.render();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(ConcurrentModificationException.class, ThrowableTestCase.assertInstanceOf(TemplateExecutionException.class, e.getCause()).getCause());
        }
    }

    @Test
    public void testError() throws Exception {
        MockApplication<?> app = this.application("template", "throwable", "error").init();
        MockClient client = app.client();
        try {
            client.render();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(UnknownError.class, e.getCause()).getCause();
        }
    }
}

