/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import juzu.UndeclaredIOException;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.application.ApplicationException;
import juzu.impl.controller.ControllerPlugin;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.inject.Export;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectManager;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.spi.ActionBridge;
import juzu.impl.request.spi.RenderBridge;
import juzu.impl.request.spi.RequestBridge;
import juzu.impl.request.spi.ResourceBridge;
import juzu.request.Phase;
import juzu.request.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Export
@Singleton
public class ApplicationContext {
    private final ApplicationDescriptor descriptor;
    final InjectManager<?, ?> injectManager;
    private final ControllerPlugin controller;
    public ArrayList<RequestFilter> lifecycles;

    @Inject
    public ApplicationContext(InjectManager injectManager, ApplicationDescriptor descriptor, ControllerPlugin controller) throws Exception {
        this.descriptor = descriptor;
        this.injectManager = injectManager;
        this.controller = controller;
    }

    private <B, I> ArrayList<RequestFilter> getLifecycles(InjectManager<B, I> manager) throws Exception {
        if (this.lifecycles == null) {
            ArrayList<RequestFilter> lifeCycles = new ArrayList<RequestFilter>();
            for (B lifeCycleBean : manager.resolveBeans(RequestFilter.class)) {
                I lifeCycleInstance = manager.create(lifeCycleBean);
                RequestFilter lifeCycle = (RequestFilter)manager.get(lifeCycleBean, lifeCycleInstance);
                lifeCycles.add(lifeCycle);
            }
            this.lifecycles = lifeCycles;
        }
        return this.lifecycles;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public List<RequestFilter> getLifecycles() {
        try {
            return this.getLifecycles(this.injectManager);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me cracefully", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.injectManager.getClassLoader();
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public InjectManager getInjectManager() {
        return this.injectManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestBridge bridge) throws ApplicationException {
        Phase phase;
        if (bridge instanceof RenderBridge) {
            phase = Phase.RENDER;
        } else if (bridge instanceof ActionBridge) {
            phase = Phase.ACTION;
        } else if (bridge instanceof ResourceBridge) {
            phase = Phase.RESOURCE;
        } else {
            throw new AssertionError();
        }
        String methodId = bridge.getProperty(RequestContext.METHOD_ID);
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : bridge.getParameters().entrySet()) {
            String name = entry.getKey();
            String[] value = entry.getValue();
            if (name.startsWith("juzu.")) {
                if (!name.equals("juzu.op")) continue;
                methodId = value[0];
                continue;
            }
            parameters.put(name, value);
        }
        ControllerMethod method = methodId == null ? (ControllerMethod)this.controller.getResolver().resolve(parameters.keySet()) : (ControllerMethod)this.controller.getResolver().resolve(phase, methodId, parameters.keySet());
        if (method == null) {
            StringBuilder sb = new StringBuilder("handle me gracefully : no method could be resolved for phase=" + (Object)((Object)phase) + " and parameters={");
            int index = 0;
            for (Map.Entry<String, String[]> entry : bridge.getParameters().entrySet()) {
                if (index++ > 0) {
                    sb.append(',');
                }
                sb.append(entry.getKey()).append('=').append(Arrays.asList((Object[])entry.getValue()));
            }
            sb.append("}");
            throw new UnsupportedOperationException(sb.toString());
        }
        Object[] args = method.getArgs(parameters);
        Request request = new Request(this, method, parameters, args, bridge);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = this.injectManager.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            ScopeController.begin(request);
            bridge.begin(request);
            request.invoke();
            try {
                bridge.end(request.getResponse());
            }
            catch (IOException e) {
                throw new UndeclaredIOException(e);
            }
        }
        finally {
            ScopeController.end();
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public Object resolveBean(String name) throws ApplicationException {
        return this.resolveBean(this.injectManager, name);
    }

    private <B, I> Object resolveBean(InjectManager<B, I> manager, String name) throws ApplicationException {
        B bean = manager.resolveBean(name);
        if (bean != null) {
            try {
                I cc = manager.create(bean);
                return manager.get(bean, cc);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
        return null;
    }
}

