/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.request.spi.MimeBridge;
import juzu.impl.utils.ParameterHashMap;
import juzu.impl.utils.ParameterMap;
import juzu.request.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLBuilder {
    public static ESCAPE_XML ESCAPE_XML = new ESCAPE_XML();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final MimeBridge bridge;
    private final ControllerMethod method;
    private ParameterMap parameterMap;
    private PropertyMap properties;

    public URLBuilder(MimeBridge bridge, ControllerMethod method) {
        PropertyMap properties = new PropertyMap();
        properties.setValue(RequestContext.METHOD_ID, method.getId());
        this.bridge = bridge;
        this.method = method;
        this.parameterMap = new ParameterHashMap();
        this.properties = properties;
    }

    public URLBuilder setParameter(String name, String value) throws NullPointerException {
        this.parameterMap.setParameter(name, value);
        return this;
    }

    public URLBuilder setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
        this.parameterMap.setParameter(name, value);
        return this;
    }

    public URLBuilder setParameters(Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
        this.parameterMap.setParameters(parameters);
        return this;
    }

    public ParameterMap getParameters() {
        return this.parameterMap;
    }

    public URLBuilder escapeXML(Boolean escapeXML) {
        this.setProperty(ESCAPE_XML, escapeXML);
        return this;
    }

    public <T> URLBuilder setProperty(PropertyType<T> propertyType, T propertyValue) throws IllegalArgumentException {
        String invalid = this.bridge.checkPropertyValidity(this.method.getPhase(), propertyType, propertyValue);
        if (invalid != null) {
            throw new IllegalArgumentException(invalid);
        }
        this.properties.setValue(propertyType, propertyValue);
        return this;
    }

    public String toString() {
        return this.bridge.renderURL(this.method.getPhase(), this.parameterMap, this.properties);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ESCAPE_XML
    extends PropertyType<Boolean> {
    }
}

