/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.request.Request;
import juzu.impl.request.spi.RequestBridge;
import juzu.impl.request.spi.servlet.ServletBridgeContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.request.SecurityContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletRequestBridge
implements RequestBridge,
HttpContext,
WindowContext {
    final ServletBridgeContext context;
    final HttpServletRequest req;
    final HttpServletResponse resp;
    final Map<String, String[]> parameters;
    final String methodId;
    protected Request request;

    ServletRequestBridge(ServletBridgeContext context, HttpServletRequest req, HttpServletResponse resp, String methodId, Map<String, String[]> parameters) {
        this.context = context;
        this.req = req;
        this.resp = resp;
        this.methodId = methodId;
        this.parameters = parameters;
        this.request = null;
    }

    @Override
    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    @Override
    public String getScheme() {
        return this.req.getScheme();
    }

    @Override
    public int getServerPort() {
        return this.req.getServerPort();
    }

    @Override
    public String getServerName() {
        return this.req.getServerName();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        if (RequestContext.METHOD_ID.equals(propertyType)) {
            return propertyType.getType().cast(this.methodId);
        }
        return null;
    }

    @Override
    public final String getNamespace() {
        return "window_ns";
    }

    @Override
    public final String getId() {
        return "window_id";
    }

    @Override
    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this;
    }

    @Override
    public final WindowContext getWindowContext() {
        return this;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return null;
    }

    @Override
    public final Scoped getRequestValue(Object key) {
        ScopedContext context = this.getRequestContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            ScopedContext context = this.getRequestContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getRequestContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getFlashValue(Object key) {
        ScopedContext context = this.getFlashContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setFlashValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getFlashContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getFlashContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getSessionValue(Object key) {
        ScopedContext context = this.getSessionContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setSessionValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getSessionContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getSessionContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getIdentityValue(Object key) {
        return null;
    }

    @Override
    public final void setIdentityValue(Object key, Scoped value) {
    }

    public <T> String checkPropertyValidity(Phase phase, PropertyType<T> propertyType, T propertyValue) {
        return null;
    }

    public final String renderURL(Phase phase, Map<String, String[]> parameters, PropertyMap properties) {
        String methodId;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.req.getScheme());
        buffer.append("://");
        buffer.append(this.req.getServerName());
        int port = this.req.getServerPort();
        if (port != 80) {
            buffer.append(':').append(port);
        }
        buffer.append(this.req.getContextPath());
        buffer.append(this.req.getServletPath());
        buffer.append("?juzu.phase=").append((Object)phase);
        String string = methodId = properties != null ? properties.getValue(RequestContext.METHOD_ID) : null;
        if (methodId != null) {
            buffer.append("&juzu.op=").append(methodId);
        }
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            try {
                String encName = URLEncoder.encode(name, "UTF-8");
                for (String value : parameter.getValue()) {
                    String encValue = URLEncoder.encode(value, "UTF-8");
                    buffer.append("&").append(encName).append('=').append(encValue);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return buffer.toString();
    }

    public void close() {
        ScopedContext context = this.getRequestContext(false);
        if (context != null) {
            context.close();
        }
    }

    protected final ScopedContext getRequestContext(boolean create) {
        ScopedContext context = (ScopedContext)this.req.getAttribute("juzu.request_scope");
        if (context == null && create) {
            context = new ScopedContext();
            this.req.setAttribute("juzu.request_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getFlashContext(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.flash_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.flash_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getSessionContext(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.session_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.session_scope", (Object)context);
        }
        return context;
    }

    @Override
    public final void begin(Request request) {
        this.request = request;
    }
}

