/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template;

import java.io.File;
import juzu.impl.compiler.Compiler;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.test.AbstractInjectTestCase;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import org.junit.Test;

public class TemplateTestCase
extends AbstractInjectTestCase {
    public TemplateTestCase(InjectImplementation di) {
        super(di);
    }

    public void _testSimple() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("template", "simple");
        Compiler compiler = helper.assertCompile();
    }

    @Test
    public void testRelativePath() throws Exception {
        MockApplication<?> app = this.application("template", "relativepath").init();
        MockClient client = app.client();
        TemplateTestCase.assertEquals((String)"relative_path_template", (String)client.render().assertStringResult());
    }

    @Test
    public void testTyped() throws Exception {
        if (this.getDI() != InjectImplementation.INJECT_GUICE) {
            MockApplication<?> app = this.application("template", "typed").init();
            MockClient client = app.client();
            TemplateTestCase.assertEquals((String)"typed_template", (String)client.render().assertStringResult());
        }
    }

    @Test
    public void testUndeclaredIOE() throws Exception {
        MockApplication<?> app = this.application("template", "ioe").init();
        MockClient client = app.client();
        TemplateTestCase.assertEquals((String)"pass", (String)client.render().assertStringResult());
    }

    @Test
    public void testSyntaxError() throws Exception {
        MockApplication<?> app = this.application("template", "syntaxerror").init();
    }
}

