/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.asset.AssetType;
import juzu.impl.application.ApplicationContext;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.asset.ManagerQualifier;
import juzu.impl.request.spi.RequestBridge;
import juzu.impl.request.spi.servlet.ServletBridgeContext;
import juzu.impl.request.spi.servlet.ServletRequestBridge;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Tools;
import juzu.test.AbstractHttpTestCase;
import juzu.test.protocol.mock.MockApplication;

public class InvocationServlet
extends HttpServlet {
    private static final ConcurrentHashMap<String, AssetServer> registry = new ConcurrentHashMap();
    private final Logger log = new Logger(){

        public void log(CharSequence msg) {
            System.out.print(msg);
        }

        public void log(CharSequence msg, Throwable t) {
            System.err.println(msg);
            t.printStackTrace(System.err);
        }
    };
    private MockApplication<?> application;
    private ServletBridgeContext bridge;

    public void init() throws ServletException {
        try {
            MockApplication<?> application = AbstractHttpTestCase.getApplication();
            AssetManager scriptManager = new AssetManager();
            application.bindBean(AssetManager.class, Collections.singleton(new ManagerQualifier(AssetType.SCRIPT)), scriptManager);
            AssetManager stylesheetManager = new AssetManager();
            application.bindBean(AssetManager.class, Collections.singleton(new ManagerQualifier(AssetType.STYLESHEET)), stylesheetManager);
            application.init();
            this.application = application;
            this.bridge = new ServletBridgeContext(application.getContext(), scriptManager, stylesheetManager, this.log);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.getServletContext().removeAttribute("asset.server");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getRequestURI().substring(req.getContextPath().length());
        String contentType = path.endsWith(".js") ? "text/javascript" : (path.endsWith(".css") ? "text/css" : null);
        if (contentType != null) {
            InputStream in = this.bridge.getScriptManager().isClassPath(path) ? this.application.getContext().getClassLoader().getResourceAsStream(path.substring(1)) : this.getServletContext().getResourceAsStream(path);
            if (in != null) {
                resp.setContentType(contentType);
                ServletOutputStream out = resp.getOutputStream();
                Tools.copy((InputStream)in, (OutputStream)out);
            } else {
                resp.sendError(404, "Path " + path + " could not be resolved");
            }
        } else {
            ServletRequestBridge requestBridge = this.bridge.create(req, resp);
            ApplicationContext context = this.application.getContext();
            context.invoke((RequestBridge)requestBridge);
        }
    }
}

