/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import juzu.impl.router.regex.JRegexFactory;
import juzu.impl.router.regex.RE;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class RegexTestCase
extends AbstractTestCase {
    @Test
    public void testLiteral() {
        RE regex = JRegexFactory.INSTANCE.compile("abc");
        RE.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)1, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
    }

    @Test
    public void testSimpleGroup1() {
        RE regex = JRegexFactory.INSTANCE.compile("(abc)");
        RE.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)2, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
        RegexTestCase.assertEquals((int)0, (int)matches[1].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[1].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[1].getValue());
    }

    @Test
    public void testSimpleGroup2() {
        RE regex = JRegexFactory.INSTANCE.compile("a(b)c");
        RE.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)2, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
        RegexTestCase.assertEquals((int)1, (int)matches[1].getStart());
        RegexTestCase.assertEquals((int)2, (int)matches[1].getEnd());
        RegexTestCase.assertEquals((String)"b", (String)matches[1].getValue());
    }

    @Test
    public void testNonCapturingGroup() {
        RE regex = JRegexFactory.INSTANCE.compile("a(?:b)c");
        RE.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)1, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
    }
}

