/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.net.URL;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ResourceResolver;
import juzu.test.protocol.mock.MockClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockApplication<P> {
    final ClassLoader classLoader;
    private final ApplicationLifeCycle<P, ?> runtime;

    public <L> MockApplication(ReadFileSystem<P> classes, ClassLoader classLoader, InjectorProvider implementation, Name name) throws Exception {
        Logger log = new Logger(){

            public void log(CharSequence msg) {
                System.out.println("[] " + msg);
            }

            public void log(CharSequence msg, Throwable t) {
                System.err.println("[] " + msg);
                t.printStackTrace(System.err);
            }
        };
        ModuleLifeCycle.Static module = new ModuleLifeCycle.Static(log, classLoader, classes);
        ApplicationLifeCycle runtime = new ApplicationLifeCycle(log, (ModuleLifeCycle)module);
        runtime.setResources(classes);
        runtime.setName(name);
        runtime.setInjectImplementation(implementation);
        runtime.setResolver(new ResourceResolver(){

            public URL resolve(String uri) {
                return null;
            }
        });
        this.classLoader = classLoader;
        this.runtime = runtime;
    }

    public MockApplication<P> init() throws Exception {
        this.runtime.refresh();
        return this;
    }

    public ApplicationLifeCycle<P, ?> getRuntime() {
        return this.runtime;
    }

    public ApplicationContext getContext() {
        return this.runtime.getContext();
    }

    void invoke(RequestBridge bridge) throws ApplicationException {
        this.runtime.getContext().invoke(bridge);
    }

    public MockClient client() {
        return new MockClient(this);
    }
}

