/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.request.Phase;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRenderBridge
extends PortletMimeBridge<RenderRequest, RenderResponse>
implements RenderBridge {
    private final Bridge bridge;
    private String title;
    private LinkedList<Element> headers = new LinkedList();

    public PortletRenderBridge(ApplicationContext application, Bridge bridge, RenderRequest request, RenderResponse response, boolean prod) {
        super(application, request, response, prod);
        this.bridge = bridge;
    }

    @Override
    protected Phase getPhase() {
        return Phase.VIEW;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (response instanceof Response.Content) {
            Response.Content content = (Response.Content)response;
            PropertyMap properties = content.getProperties();
            String title = properties.getValue(PropertyType.TITLE);
            if (title != null) {
                this.title = title;
            }
            Iterable<Asset> scriptsProp = properties.getValues(PropertyType.SCRIPT);
            Iterable<Asset> stylesheetsProp = properties.getValues(PropertyType.STYLESHEET);
            Iterable<Map.Entry<String, String>> metas = properties.getValues(PropertyType.META_TAG);
            if (metas != null) {
                for (Map.Entry<String, String> entry : metas) {
                    Element elt = ((RenderResponse)this.resp).createElement("meta");
                    elt.setAttribute("name", entry.getKey());
                    elt.setAttribute("content", entry.getValue());
                    this.headers.add(elt);
                }
            }
            if (stylesheetsProp != null) {
                Iterable<Asset.Value> stylesheets = this.bridge.runtime.getStylesheetManager().resolveAssets(stylesheetsProp);
                for (Asset.Value stylesheet : stylesheets) {
                    int pos = stylesheet.getURI().lastIndexOf(46);
                    String ext = pos == -1 ? "css" : stylesheet.getURI().substring(pos + 1);
                    Element elt = ((RenderResponse)this.resp).createElement("link");
                    elt.setAttribute("media", "screen");
                    elt.setAttribute("rel", "stylesheet");
                    elt.setAttribute("type", "text/" + ext);
                    elt.setAttribute("href", this.getAssetURL(stylesheet));
                    this.headers.add(elt);
                }
            }
            if (scriptsProp != null) {
                Iterable<Asset.Value> scripts = this.bridge.runtime.getScriptManager().resolveAssets(scriptsProp);
                for (Asset.Value script : scripts) {
                    String url = this.getAssetURL(script);
                    Element elt = ((RenderResponse)this.resp).createElement("script");
                    elt.setAttribute("type", "text/javascript");
                    elt.setAttribute("src", url);
                    Comment comment = elt.getOwnerDocument().createComment(this.request.getApplication().getName() + " script ");
                    elt.appendChild(comment);
                    this.headers.add(elt);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        super.setResponse(response);
    }

    private String getAssetURL(Asset.Value asset) {
        String url;
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                StringBuilder sb = new StringBuilder();
                if (!uri.startsWith("/")) {
                    sb.append(((RenderRequest)this.req).getContextPath());
                    sb.append('/');
                }
                sb.append(uri);
                url = sb.toString();
                break;
            }
            case CLASSPATH: {
                if (this.prod) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((RenderRequest)this.req).getContextPath()).append("/assets");
                    if (!uri.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(uri);
                    url = sb.toString();
                    break;
                }
                ResourceURL r = ((RenderResponse)this.resp).createResourceURL();
                r.setParameter("juzu.request", "assets");
                r.setResourceID(uri);
                url = r.toString();
                break;
            }
            case URL: {
                url = uri;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return url;
    }

    @Override
    public void end() {
        super.end();
        ScopedContext context = this.getFlashContext(false);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public void send() throws IOException {
        if (this.title != null) {
            ((RenderResponse)this.resp).setTitle(this.title);
        }
        for (Element elt : this.headers) {
            ((RenderResponse)this.resp).addProperty("javax.portlet.markup.head.element", elt);
        }
        super.send();
    }
}

