/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.spi.servlet.Handler;
import juzu.impl.bridge.spi.servlet.ServletActionBridge;
import juzu.impl.bridge.spi.servlet.ServletRenderBridge;
import juzu.impl.bridge.spi.servlet.ServletRequestBridge;
import juzu.impl.bridge.spi.servlet.ServletResourceBridge;
import juzu.impl.common.DevClassLoader;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Name;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.common.URIWriter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.plugin.application.descriptor.ApplicationModuleDescriptor;
import juzu.impl.plugin.module.Module;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.request.Method;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.request.Phase;

public class ServletBridge
extends HttpServlet {
    private static final Phase[] GET_PHASES = new Phase[]{Phase.VIEW, Phase.ACTION, Phase.RESOURCE};
    private static final Phase[] POST_PHASES = new Phase[]{Phase.ACTION, Phase.VIEW, Phase.RESOURCE};
    Router root;
    List<Handler> handlers;
    Handler defaultHandler;
    ModuleLifeCycle moduleLifeCycle;
    AssetServer server;
    WarFileSystem resources;
    Logger log;

    public void init() throws ServletException {
        ModuleLifeCycle moduleLifeCycle;
        String srcPath;
        final ServletConfig config = this.getServletConfig();
        Logger log = new Logger(){

            public void log(CharSequence msg) {
                System.out.println("[" + config.getServletName() + "] " + msg);
            }

            public void log(CharSequence msg, Throwable t) {
                System.err.println("[" + config.getServletName() + "] " + msg);
                t.printStackTrace();
            }
        };
        AssetServer server = (AssetServer)config.getServletContext().getAttribute("asset.server");
        if (server == null) {
            server = new AssetServer();
            config.getServletContext().setAttribute("asset.server", (Object)server);
        }
        ReadFileSystem sourcePath = (srcPath = config.getInitParameter("juzu.src_path")) != null ? new DiskFileSystem(new File(srcPath)) : WarFileSystem.create(config.getServletContext(), "/WEB-INF/src/");
        WarFileSystem resources = WarFileSystem.create(config.getServletContext(), "/WEB-INF/");
        int runMode = BridgeConfig.getRunMode((Map<String, String>)new SimpleMap<String, String>(){

            @Override
            protected Iterator<String> keys() {
                return Tools.iterator("juzu.run_mode");
            }

            @Override
            public String get(Object key) {
                return key.equals("juzu.run_mode") ? config.getInitParameter("juzu.run_mode") : null;
            }
        });
        switch (runMode) {
            case 1: {
                moduleLifeCycle = new ModuleLifeCycle.Dynamic(log, new DevClassLoader(Thread.currentThread().getContextClassLoader()), sourcePath);
                break;
            }
            default: {
                moduleLifeCycle = new ModuleLifeCycle.Static(log, Thread.currentThread().getContextClassLoader(), WarFileSystem.create(config.getServletContext(), "/WEB-INF/classes/"));
            }
        }
        this.moduleLifeCycle = moduleLifeCycle;
        this.server = server;
        this.resources = resources;
        this.log = log;
    }

    static ServletException wrap(Throwable e) {
        return e instanceof ServletException ? (ServletException)e : new ServletException("Could not find an application to start", e);
    }

    protected String getApplicationName(ServletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private void refresh() throws ServletException {
        try {
            boolean stale = this.moduleLifeCycle.refresh();
            if (stale) {
                this.root = null;
                this.handlers = null;
                this.defaultHandler = null;
            }
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        if (this.root == null) {
            Module module;
            try {
                URL cfg = this.moduleLifeCycle.getClassLoader().getResource("juzu/config.json");
                String s = Tools.read(cfg);
                JSON json = (JSON)JSON.parse(s);
                module = new Module(this.moduleLifeCycle.getClassLoader(), json);
            }
            catch (Exception e) {
                throw ServletBridge.wrap(e);
            }
            ApplicationModuleDescriptor desc = (ApplicationModuleDescriptor)module.getDescriptors().get("application");
            HashMap<String, Bridge> applications = new HashMap<String, Bridge>();
            for (final Name name : desc.getNames()) {
                BridgeConfig bridgeConfig;
                try {
                    bridgeConfig = new BridgeConfig((Map<String, String>)new SimpleMap<String, String>(){

                        @Override
                        protected Iterator<String> keys() {
                            return BridgeConfig.NAMES.iterator();
                        }

                        @Override
                        public String get(Object key) {
                            if ("juzu.app_name".equals(key)) {
                                return name.toString();
                            }
                            if (BridgeConfig.NAMES.contains(key)) {
                                return ServletBridge.this.getServletConfig().getInitParameter((String)key);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw ServletBridge.wrap(e);
                }
                Bridge bridge = new Bridge(this.moduleLifeCycle);
                bridge.config = bridgeConfig;
                bridge.resources = this.resources;
                bridge.server = this.server;
                bridge.log = this.log;
                bridge.resolver = new ResourceResolver(){

                    public URL resolve(String uri) {
                        try {
                            return ServletBridge.this.getServletConfig().getServletContext().getResource(uri);
                        }
                        catch (MalformedURLException e) {
                            return null;
                        }
                    }
                };
                applications.put(name.toString(), bridge);
            }
            String applicationName = this.getApplicationName(this.getServletConfig());
            LinkedHashMap handlers = new LinkedHashMap();
            Handler defaultHandler = null;
            Router root = new Router();
            for (Map.Entry entry : applications.entrySet()) {
                Handler handler = new Handler(root, (Bridge)entry.getValue());
                if (((String)entry.getKey()).equals(applicationName)) {
                    defaultHandler = handler;
                }
                handlers.put(entry.getKey(), handler);
            }
            this.root = root;
            this.handlers = new ArrayList(handlers.values());
            this.defaultHandler = defaultHandler;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<Phase, MethodHandle> m;
        RouteMatch match_;
        this.refresh();
        String path = req.getRequestURI().substring(req.getContextPath().length());
        Handler requestHandler = null;
        RouteMatch requestMatch = null;
        if (path != null && (match_ = this.root.route(path, Collections.<String, String[]>emptyMap())) != null) {
            for (Handler handler : this.handlers) {
                if (!handler.routes.contains(match_.getRoute())) continue;
                requestMatch = match_;
                requestHandler = handler;
                break;
            }
        }
        if (requestHandler == null && this.defaultHandler != null) {
            requestHandler = this.defaultHandler;
            requestMatch = this.defaultHandler.root.route(path, Collections.<String, String[]>emptyMap());
        }
        Method requestMethod = null;
        Map<String, String[]> requestParameters = Collections.emptyMap();
        if (requestMatch != null && (m = requestHandler.routeMap2.get(requestMatch.getRoute())) != null) {
            Phase[] phases;
            if ("GET".equals(req.getMethod())) {
                phases = GET_PHASES;
            } else if ("POST".equals(req.getMethod())) {
                phases = POST_PHASES;
            } else {
                throw new UnsupportedOperationException("handle me gracefully");
            }
            for (Phase phase : phases) {
                MethodHandle handle = m.get(phase);
                if (handle == null) continue;
                requestMethod = requestHandler.bridge.runtime.getDescriptor().getControllers().getMethodByHandle(handle);
                if (requestMatch.getMatched().size() <= 0 && req.getParameterMap().size() <= 0) break;
                requestParameters = new HashMap<String, String[]>();
                for (Map.Entry entry : req.getParameterMap().entrySet()) {
                    requestParameters.put((String)entry.getKey(), (String[])((String[])entry.getValue()).clone());
                }
                for (Map.Entry<Object, Object> entry : requestMatch.getMatched().entrySet()) {
                    requestParameters.put(((PathParam)entry.getKey()).getName(), new String[]{(String)entry.getValue()});
                }
                break;
            }
        }
        if (requestMethod == null) {
            URL url;
            if (path != null && path.length() > 1 && !path.startsWith("/WEB-INF/") && (url = this.getServletContext().getResource(path)) != null) {
                RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher("default");
                dispatcher.include((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            if (requestHandler != null) {
                requestMethod = requestHandler.bridge.runtime.getDescriptor().getControllers().getResolver().resolve(Phase.VIEW, Collections.<String>emptySet());
            }
        }
        if (requestMethod == null) {
            resp.sendError(404);
        } else {
            Response response;
            ServletRequestBridge requestBridge;
            if (requestMatch == null) {
                Route requestRoute = requestHandler.routeMap.get(requestMethod.getHandle());
                if (requestRoute == null) {
                    requestRoute = requestHandler.root;
                }
                if ((requestMatch = requestRoute.matches(Collections.<String, String>emptyMap())) != null) {
                    StringBuilder sb = new StringBuilder();
                    requestMatch.render(new URIWriter(sb));
                    if (!sb.toString().equals(path)) {
                        String redirect = req.getScheme() + "://" + req.getServerName() + (req.getServerPort() != 80 ? ":" + req.getServerPort() : "") + req.getContextPath() + sb;
                        resp.sendRedirect(redirect);
                        return;
                    }
                }
            }
            if (requestMethod.getPhase() == Phase.ACTION) {
                requestBridge = new ServletActionBridge(requestHandler.bridge.runtime.getContext(), requestHandler, req, resp, requestMethod, requestParameters);
            } else if (requestMethod.getPhase() == Phase.VIEW) {
                requestBridge = new ServletRenderBridge(requestHandler.bridge.runtime.getContext(), requestHandler, req, resp, requestMethod, requestParameters);
            } else if (requestMethod.getPhase() == Phase.RESOURCE) {
                requestBridge = new ServletResourceBridge(requestHandler.bridge.runtime.getContext(), requestHandler, req, resp, requestMethod, requestParameters);
            } else {
                throw new ServletException("Cannot decode phase");
            }
            try {
                requestHandler.bridge.invoke(requestBridge);
            }
            catch (Throwable throwable) {
                throw ServletBridge.wrap(throwable);
            }
            if (requestBridge instanceof ServletActionBridge && (response = ((ServletActionBridge)requestBridge).response) instanceof Response.View) {
                Response.View update = (Response.View)response;
                Boolean redirect = response.getProperties().getValue(PropertyType.REDIRECT_AFTER_ACTION);
                if (redirect != null && !redirect.booleanValue()) {
                    Method desc = requestHandler.bridge.runtime.getDescriptor().getControllers().getMethodByHandle(update.getTarget());
                    requestBridge = new ServletRenderBridge(requestHandler.bridge.runtime.getContext(), requestHandler, req, resp, desc, update.getParameters());
                    try {
                        requestHandler.bridge.invoke(requestBridge);
                    }
                    catch (Throwable throwable) {
                        throw ServletBridge.wrap(throwable);
                    }
                }
            }
            requestBridge.send();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

