/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import juzu.AmbiguousResolutionException;
import juzu.impl.common.Filter;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIContext
extends InjectionContext<Bean<?>, CreationalContext<?>> {
    static final ThreadLocal<CDIContext> boot = new ThreadLocal();
    private final Container container;
    private BeanManager manager;
    final ArrayList<AbstractBean> boundBeans;
    final ClassLoader classLoader;
    final ArrayList<Bean> beans;
    final Filter<Class<?>> filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDIContext(Container container, Filter<Class<?>> filter, ArrayList<AbstractBean> boundBeans) throws Exception {
        this.boundBeans = boundBeans;
        this.beans = new ArrayList();
        this.filter = filter;
        boot.set(this);
        try {
            container.start();
            Object var5_4 = null;
            boot.set(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            boot.set(null);
            throw throwable;
        }
        this.classLoader = container.getClassLoader();
        this.manager = container.getManager();
        this.container = container;
    }

    @Override
    public InjectorProvider getImplementation() {
        return InjectorProvider.CDI_WELD;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Bean<?> resolveBean(Class<?> type) {
        Set beans = this.manager.getBeans(type, new Annotation[0]);
        switch (beans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bean)beans.iterator().next();
            }
        }
        throw new AmbiguousResolutionException("Could not resolve bean of type " + type + ": " + beans);
    }

    @Override
    public Iterable<Bean<?>> resolveBeans(Class<?> type) {
        List resolved = Collections.emptyList();
        for (int i = 0; i < this.beans.size(); ++i) {
            Bean bean = this.beans.get(i);
            if (!type.isAssignableFrom(bean.getBeanClass())) continue;
            if (resolved.isEmpty()) {
                resolved = new ArrayList();
            }
            resolved.add(bean);
        }
        return this.manager.getBeans(type, new Annotation[0]);
    }

    @Override
    public Bean<?> resolveBean(String name) {
        Set beans = this.manager.getBeans(name);
        switch (beans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bean)beans.iterator().next();
            }
        }
        throw new AmbiguousResolutionException("Could not resolve bean of type " + name + ": " + beans);
    }

    @Override
    public CreationalContext<?> create(Bean<?> bean) {
        return this.manager.createCreationalContext(bean);
    }

    @Override
    public void release(Bean<?> bean, CreationalContext<?> instance) {
        instance.release();
    }

    @Override
    public Object get(Bean<?> bean, CreationalContext<?> instance) throws InvocationTargetException {
        try {
            return this.manager.getReference(bean, (Type)bean.getBeanClass(), instance);
        }
        catch (CreationException e) {
            e.printStackTrace();
            throw new InvocationTargetException(e.getCause());
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public void shutdown() {
        this.container.stop();
    }
}

