/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import juzu.Response;
import juzu.UndeclaredIOException;
import juzu.impl.bridge.EventBridge;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ApplicationContext {
    private final ApplicationDescriptor descriptor;
    final InjectionContext<?, ?> injectionContext;
    private final ControllerPlugin controller;
    public ArrayList<RequestFilter> lifecycles;

    @Inject
    public ApplicationContext(InjectionContext injectionContext, ApplicationDescriptor descriptor, ControllerPlugin controller) throws Exception {
        this.descriptor = descriptor;
        this.injectionContext = injectionContext;
        this.controller = controller;
    }

    private <B, I> ArrayList<RequestFilter> getLifecycles(InjectionContext<B, I> manager) throws Exception {
        if (this.lifecycles == null) {
            ArrayList<RequestFilter> lifeCycles = new ArrayList<RequestFilter>();
            for (B lifeCycleBean : manager.resolveBeans(RequestFilter.class)) {
                I lifeCycleInstance = manager.create(lifeCycleBean);
                RequestFilter lifeCycle = (RequestFilter)manager.get(lifeCycleBean, lifeCycleInstance);
                lifeCycles.add(lifeCycle);
            }
            this.lifecycles = lifeCycles;
        }
        return this.lifecycles;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public List<RequestFilter> getLifecycles() {
        try {
            return this.getLifecycles(this.injectionContext);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me cracefully", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.injectionContext.getClassLoader();
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public InjectionContext<?, ?> getInjectionContext() {
        return this.injectionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestBridge bridge) throws ApplicationException {
        block16: {
            Phase phase;
            if (bridge instanceof RenderBridge) {
                phase = Phase.VIEW;
            } else if (bridge instanceof ActionBridge) {
                phase = Phase.ACTION;
            } else if (bridge instanceof EventBridge) {
                phase = Phase.EVENT;
            } else if (bridge instanceof ResourceBridge) {
                phase = Phase.RESOURCE;
            } else {
                throw new AssertionError();
            }
            Map<String, String[]> parameters = bridge.getParameters();
            MethodHandle handle = bridge.getTarget();
            Method method = this.controller.getDescriptor().getMethodByHandle(handle);
            if (method == null) {
                StringBuilder sb = new StringBuilder("handle me gracefully : no method could be resolved for phase=").append(phase).append(" handle=").append(handle).append(" parameters={");
                int index = 0;
                for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                    if (index++ > 0) {
                        sb.append(',');
                    }
                    sb.append(entry.getKey()).append('=').append(Arrays.asList((Object[])entry.getValue()));
                }
                sb.append("}");
                throw new UnsupportedOperationException(sb.toString());
            }
            Request request = new Request(this, method, parameters, bridge);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader classLoader = this.injectionContext.getClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                ScopeController.begin(request);
                bridge.begin(request);
                request.invoke();
                Response response = request.getResponse();
                if (response == null) break block16;
                try {
                    bridge.setResponse(response);
                }
                catch (IOException e) {
                    throw new UndeclaredIOException(e);
                }
            }
            finally {
                bridge.end();
                ScopeController.end();
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    public Object resolveBean(String name) throws ApplicationException {
        return this.resolveBean(this.injectionContext, name);
    }

    private <B, I> Object resolveBean(InjectionContext<B, I> manager, String name) throws ApplicationException {
        B bean = manager.resolveBean(name);
        if (bean != null) {
            try {
                I cc = manager.create(bean);
                return manager.get(bean, cc);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
        return null;
    }
}

