/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.jar.JarFile;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.NameLiteral;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.jar.JarFileSystem;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.spring.SpringBuilder;
import juzu.impl.plugin.application.ApplicationBootstrap;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ClassLoaderResolver;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLifeCycle<P, R> {
    protected final Logger logger;
    protected Name name;
    protected InjectorProvider injectImplementation;
    protected ReadFileSystem<R> resources;
    protected ApplicationContext context;
    protected AssetServer assetServer;
    protected AssetManager stylesheetManager;
    protected AssetManager scriptManager;
    protected ApplicationDescriptor descriptor;
    protected ApplicationBootstrap bootstrap;
    protected ResourceResolver resolver;
    private final ModuleLifeCycle<R, P> module;

    public ApplicationLifeCycle(Logger logger, ModuleLifeCycle<R, P> module) {
        this.logger = logger;
        this.module = module;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public InjectorProvider getInjectImplementation() {
        return this.injectImplementation;
    }

    public void setInjectImplementation(InjectorProvider injectImplementation) {
        this.injectImplementation = injectImplementation;
    }

    public ReadFileSystem<R> getResources() {
        return this.resources;
    }

    public void setResources(ReadFileSystem<R> resources) {
        this.resources = resources;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public AssetServer getAssetServer() {
        return this.assetServer;
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public void setAssetServer(AssetServer assetServer) {
        if (assetServer != null) {
            assetServer.register(this);
        }
        if (this.assetServer != null) {
            this.assetServer.unregister(this);
        }
        this.assetServer = assetServer;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ModuleLifeCycle<R, P> getModule() {
        return this.module;
    }

    public boolean refresh() throws Exception {
        boolean changed = this.getModule().refresh();
        if (this.context != null && changed) {
            this.context = null;
        }
        if (this.context == null) {
            this.logger.log("Building application");
            this.doBoot();
            return true;
        }
        return false;
    }

    protected final void doBoot() throws Exception {
        R springName;
        ReadFileSystem<P> classes = this.getModule().getClasses();
        Name fqn = this.name.append("Application");
        Class<?> clazz = this.getModule().getClassLoader().loadClass(fqn.toString());
        ApplicationDescriptor descriptor = ApplicationDescriptor.create(clazz);
        URL mainURL = ApplicationBootstrap.class.getProtectionDomain().getCodeSource().getLocation();
        if (mainURL == null) {
            throw new Exception("Cannot find juzu jar");
        }
        if (!mainURL.getProtocol().equals("file")) {
            throw new Exception("Cannot handle " + mainURL);
        }
        File file = new File(mainURL.toURI());
        ReadFileSystem libs = file.isDirectory() ? new DiskFileSystem(file) : new JarFileSystem(new JarFile(file));
        Injector injector = (Injector)this.injectImplementation.get();
        injector.addFileSystem(classes);
        injector.addFileSystem(libs);
        injector.setClassLoader(this.getModule().getClassLoader());
        if (injector instanceof SpringBuilder && (springName = this.resources.getPath("spring.xml")) != null) {
            URL configurationURL = this.resources.getURL(springName);
            ((SpringBuilder)injector).setConfigurationURL(configurationURL);
        }
        ClassLoaderResolver resolver = new ClassLoaderResolver(this.getModule().getClassLoader());
        injector.bindBean(ResourceResolver.class, Collections.singletonList(new NameLiteral("juzu.resource_resolver.classpath")), resolver);
        injector.bindBean(ResourceResolver.class, Collections.singletonList(new NameLiteral("juzu.resource_resolver.server")), this.resolver);
        ApplicationBootstrap bootstrap = new ApplicationBootstrap(injector, descriptor);
        this.logger.log("Starting " + descriptor.getName());
        bootstrap.start();
        AssetPlugin assetPlugin = bootstrap.getContext().getInjectionContext().get(AssetPlugin.class).get();
        this.context = bootstrap.getContext();
        this.scriptManager = assetPlugin.getScriptManager();
        this.stylesheetManager = assetPlugin.getStylesheetManager();
        this.descriptor = descriptor;
        this.bootstrap = bootstrap;
    }

    public void shutdown() {
        if (this.bootstrap != null) {
            this.bootstrap.stop();
        }
    }
}

