/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import juzu.asset.Asset;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.asset.AssetNode;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetManager {
    private final LinkedHashMap<String, AssetNode> assets = new LinkedHashMap();
    private final HashMap<String, URL> resources = new HashMap();

    public void addAsset(AssetMetaData data, URL url) throws NullPointerException, IllegalArgumentException {
        String id = data.id;
        if (id != null) {
            if (!this.assets.keySet().contains(id)) {
                AssetNode asset = new AssetNode(id, data.location, data.value, data.dependencies);
                for (AssetNode deployed : this.assets.values()) {
                    if (deployed.iDependOn.contains(id)) {
                        asset.dependsOnMe = Tools.addToHashSet(asset.dependsOnMe, deployed.id);
                    }
                    if (!asset.iDependOn.contains(deployed.id)) continue;
                    deployed.dependsOnMe = Tools.addToHashSet(deployed.dependsOnMe, id);
                }
                this.assets.put(id, asset);
            } else {
                return;
            }
        }
        switch (data.location) {
            case CLASSPATH: 
            case SERVER: {
                this.resources.put(data.getValue(), url);
                break;
            }
        }
    }

    public URL resolveAsset(String path) {
        return this.resources.get(path);
    }

    public Iterable<Asset.Value> resolveAssets(Iterable<Asset> scripts) throws NullPointerException, IllegalArgumentException {
        LinkedHashMap<String, HashSet<String>> sub = new LinkedHashMap<String, HashSet<String>>();
        for (Asset script : scripts) {
            if (script instanceof Asset.Value) continue;
            AssetNode asset = this.assets.get(((Asset.Id)script).getValue());
            if (asset != null) {
                sub.put(asset.id, new HashSet<String>(asset.iDependOn));
                continue;
            }
            throw new IllegalArgumentException("Cannot resolve asset " + script);
        }
        LinkedList<Asset.Value> resolved = new LinkedList<Asset.Value>();
        while (sub.size() > 0) {
            boolean found = false;
            Iterator i = sub.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                i.remove();
                AssetNode asset = this.assets.get(entry.getKey());
                resolved.addLast(Asset.of(asset.getLocation(), asset.getValue()));
                for (String dependency : asset.dependsOnMe) {
                    HashSet foo = (HashSet)sub.get(dependency);
                    if (foo == null) continue;
                    foo.remove(entry.getKey());
                }
                found = true;
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Cannot satisfy asset dependencies:\n");
            for (Map.Entry entry : sub.entrySet()) {
                sb.append((String)entry.getKey()).append(" -> ").append(entry.getValue());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        for (Asset script : scripts) {
            if (!(script instanceof Asset.Value)) continue;
            Asset.Value script1 = (Asset.Value)script;
            String uri = script1.getURI();
            resolved.addLast(Asset.of(script1.getLocation(), uri));
        }
        return resolved;
    }
}

