/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import juzu.Response;
import juzu.impl.bridge.spi.MimeBridge;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.plugin.application.Application;
import juzu.io.AppendableStream;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    PortletMimeBridge(Application application, Rq request, Rs response, PortletConfig config, boolean prod) {
        super(application, request, response, config, prod);
    }

    @Override
    public void send() throws IOException, PortletException {
        if (this.response instanceof Response.Content) {
            Response.Content content = (Response.Content)this.response;
            String mimeType = content.getMimeType();
            if (mimeType != null) {
                ((MimeResponse)this.resp).setContentType(mimeType);
            }
            this.sendProperties();
            if (content.getKind() == Stream.Char.class) {
                content.send(new AppendableStream(((MimeResponse)this.resp).getWriter()));
            } else {
                content.send(new BinaryOutputStream(((MimeResponse)this.resp).getPortletOutputStream()));
            }
        } else if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            throw new PortletException(error.getCause());
        }
    }
}

