/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.Asset;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.common.JSON;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.asset.AssetDescriptor;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.resource.ResourceResolver;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPlugin
extends ApplicationPlugin
implements RequestFilter {
    private Asset[] scripts;
    private Asset[] stylesheets;
    private AssetDescriptor descriptor;
    @Inject
    @Named(value="juzu.asset_manager.script")
    AssetManager scriptManager;
    @Inject
    @Named(value="juzu.asset_manager.stylesheet")
    AssetManager stylesheetManager;
    @Inject
    @Named(value="juzu.resource_resolver.classpath")
    ResourceResolver classPathResolver;
    @Inject
    @Named(value="juzu.resource_resolver.server")
    ResourceResolver serverResolver;

    public AssetPlugin() {
        super("asset");
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    @Override
    public Descriptor init(ApplicationDescriptor application, JSON config) throws Exception {
        if (config != null) {
            String packageName = config.getString("package");
            AssetLocation location = AssetLocation.safeValueOf(config.getString("location"));
            if (location == null) {
                location = AssetLocation.CLASSPATH;
            }
            List<AssetMetaData> scripts = this.load(packageName, location, config.getList("scripts", JSON.class));
            List<AssetMetaData> stylesheets = this.load(packageName, location, config.getList("stylesheets", JSON.class));
            this.descriptor = new AssetDescriptor(scripts, stylesheets);
            return this.descriptor;
        }
        this.descriptor = new AssetDescriptor(Collections.<AssetMetaData>emptyList(), Collections.<AssetMetaData>emptyList());
        return this.descriptor;
    }

    private List<AssetMetaData> load(String packageName, AssetLocation defaultLocation, List<? extends JSON> scripts) throws Exception {
        List<AssetMetaData> abc = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            abc = new ArrayList<AssetMetaData>();
            for (JSON jSON : scripts) {
                String value;
                String id = jSON.getString("id");
                AssetLocation location = AssetLocation.safeValueOf(jSON.getString("location"));
                if (location == null) {
                    location = defaultLocation;
                }
                if (!(value = jSON.getString("src")).startsWith("/") && location == AssetLocation.CLASSPATH) {
                    value = "/" + packageName.replace('.', '/') + "/" + value;
                }
                AssetMetaData descriptor = new AssetMetaData(id, location, value, jSON.getArray("depends", String.class));
                abc.add(descriptor);
            }
        }
        return abc;
    }

    @PostConstruct
    public void start() throws Exception {
        this.scripts = this.process(this.descriptor.getScripts(), this.scriptManager);
        this.stylesheets = this.process(this.descriptor.getStylesheets(), this.stylesheetManager);
    }

    private Asset[] process(List<AssetMetaData> data, AssetManager manager) throws Exception {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (AssetMetaData script : data) {
            URL url;
            String id = script.getId();
            if (id != null) {
                assets.add(Asset.ref(id));
            } else {
                assets.add(Asset.of(script.getLocation(), script.getValue()));
            }
            AssetLocation location = script.getLocation();
            if (location == AssetLocation.CLASSPATH) {
                url = this.classPathResolver.resolve(script.getValue());
                if (url == null) {
                    throw new Exception("Could not resolve classpath assets " + script.getValue());
                }
            } else if (location == AssetLocation.SERVER && !script.getValue().startsWith("/")) {
                url = this.serverResolver.resolve("/" + script.getValue());
                if (url == null) {
                    throw new Exception("Could not resolve server assets " + script.getValue());
                }
            } else {
                url = null;
            }
            manager.addAsset(script, url);
        }
        return assets.toArray(new Asset[assets.size()]);
    }

    @Override
    public void invoke(Request request) {
        Response response;
        request.invoke();
        if (request.getContext().getPhase() == Phase.VIEW && (response = request.getResponse()) instanceof Response.Render && (this.scripts.length > 0 || this.stylesheets.length > 0)) {
            Response.Render render = (Response.Render)response;
            PropertyMap properties = new PropertyMap(render.getProperties());
            properties.addValues(PropertyType.STYLESHEET, this.stylesheets);
            properties.addValues(PropertyType.SCRIPT, this.scripts);
            request.setResponse(new Response.Render(properties, render.getStreamable()));
        }
    }
}

