/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.composite;

import java.io.IOException;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.composite.CompositeFileSystem;
import juzu.impl.fs.spi.composite.Context;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class CompositeFileSystemTestCase
extends AbstractTestCase {
    @Test
    public void testFoo() throws IOException {
        RAMFileSystem ramFS = new RAMFileSystem();
        ramFS.setContent(new String[]{"a", "b"}, new Content((CharSequence)"foo"));
        CompositeFileSystem composite = new CompositeFileSystem(new ReadFileSystem[]{ramFS});
        Context root = composite.getRoot();
        Context a = composite.getChild(root, "a");
        CompositeFileSystemTestCase.assertNotNull((Object)a);
        CompositeFileSystemTestCase.assertEquals((Object)PathType.DIR, (Object)composite.typeOf(a));
        Context b = composite.getChild(a, "b");
        CompositeFileSystemTestCase.assertNotNull((Object)b);
        CompositeFileSystemTestCase.assertEquals((Object)PathType.FILE, (Object)composite.typeOf(b));
        Timestamped content = composite.getContent(b);
        CompositeFileSystemTestCase.assertNotNull((Object)content);
        CompositeFileSystemTestCase.assertEquals((String)"foo", (String)((Object)((Content)content.getObject()).getCharSequence()).toString());
    }
}

