/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import juzu.Response;
import juzu.impl.bridge.spi.MimeBridge;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.plugin.application.Application;
import juzu.io.AppendableStream;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    private Response.Content<?> response;

    PortletMimeBridge(Application application, Rq request, Rs response, boolean prod) {
        super(application, request, response, prod);
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (!(response instanceof Response.Content)) {
            throw new IllegalArgumentException();
        }
        this.response = (Response.Content)response;
    }

    @Override
    public void send() throws IOException {
        if (this.response != null) {
            String mimeType = this.response.getMimeType();
            if (mimeType != null) {
                ((MimeResponse)this.resp).setContentType(mimeType);
            }
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    ((MimeResponse)this.resp).addProperty((String)entry.getKey(), value);
                }
            }
            if (this.response.getKind() == Stream.Char.class) {
                this.response.send(new AppendableStream(((MimeResponse)this.resp).getWriter()));
            } else {
                this.response.send(new BinaryOutputStream(((MimeResponse)this.resp).getPortletOutputStream()));
            }
        }
    }
}

