/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import juzu.Scope;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.Filter;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.NameLiteral;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.spring.SpringBuilder;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ClassLoaderResolver;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLifeCycle<P, R>
implements Closeable {
    private final Name name;
    private final InjectorProvider injectorProvider;
    private final Logger logger;
    private final ReadFileSystem<R> resources;
    private final ResourceResolver resourceResolver;
    private final AssetServer assetServer;
    private final ModuleLifeCycle<R, P> module;
    private ApplicationDescriptor descriptor;
    private AssetManager stylesheetManager;
    private AssetManager scriptManager;
    private InjectionContext<?, ?> injectionContext;
    private BeanLifeCycle<Application> application;

    public ApplicationLifeCycle(Logger logger, ModuleLifeCycle<R, P> module, InjectorProvider injectorProvider, Name name, ReadFileSystem<R> resources, AssetServer assetServer, ResourceResolver resourceResolver) {
        this.logger = logger;
        this.module = module;
        this.injectorProvider = injectorProvider;
        this.name = name;
        this.resources = resources;
        this.assetServer = assetServer;
        this.resourceResolver = resourceResolver;
    }

    public Name getName() {
        return this.name;
    }

    public Application getApplication() {
        return this.application != null ? this.application.peek() : null;
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ModuleLifeCycle<R, P> getModule() {
        return this.module;
    }

    public boolean refresh() throws Exception {
        boolean changed = this.getModule().refresh();
        if (this.application != null && changed) {
            this.stop();
        }
        if (this.application == null) {
            this.logger.log("Building application");
            this.start();
            return true;
        }
        return false;
    }

    protected final void start() throws Exception {
        R springName;
        ReadFileSystem<P> classes = this.getModule().getClasses();
        Name fqn = this.name.append("Application");
        Class<?> clazz = this.getModule().getClassLoader().loadClass(fqn.toString());
        ApplicationDescriptor descriptor = ApplicationDescriptor.create(clazz);
        URL mainURL = ApplicationLifeCycle.class.getProtectionDomain().getCodeSource().getLocation();
        if (mainURL == null) {
            throw new Exception("Cannot find juzu jar");
        }
        ReadFileSystem<?> libs = ReadFileSystem.create(mainURL);
        Injector injector = (Injector)this.injectorProvider.get();
        injector.addFileSystem(classes);
        injector.addFileSystem(libs);
        injector.setClassLoader(this.getModule().getClassLoader());
        if (injector instanceof SpringBuilder && (springName = this.resources.getPath("spring.xml")) != null) {
            URL configurationURL = this.resources.getURL(springName);
            ((SpringBuilder)injector).setConfigurationURL(configurationURL);
        }
        ClassLoaderResolver resolver = new ClassLoaderResolver(this.getModule().getClassLoader());
        injector.bindBean(ResourceResolver.class, Collections.singletonList(new NameLiteral("juzu.resource_resolver.classpath")), resolver);
        injector.bindBean(ResourceResolver.class, Collections.singletonList(new NameLiteral("juzu.resource_resolver.server")), this.resourceResolver);
        this.logger.log("Starting " + descriptor.getName());
        InjectionContext injectionContext = this.doStart(descriptor, injector);
        AssetPlugin assetPlugin = injectionContext.get(AssetPlugin.class).get();
        BeanLifeCycle<Application> application = injectionContext.get(Application.class);
        if (this.assetServer != null) {
            this.assetServer.register(this);
        }
        this.injectionContext = injectionContext;
        this.scriptManager = assetPlugin.getScriptManager();
        this.stylesheetManager = assetPlugin.getStylesheetManager();
        this.descriptor = descriptor;
        this.application = application;
        try {
            application.get();
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
    }

    private <B, I> InjectionContext<B, I> doStart(final ApplicationDescriptor descriptor, Injector injector) throws ApplicationException {
        InjectionContext<?, ?> injectionContext;
        injector.bindBean(ApplicationDescriptor.class, null, descriptor);
        injector.declareBean(Application.class, null, null, null);
        for (Scope scope : Scope.values()) {
            injector.addScope(scope);
        }
        for (ApplicationPlugin plugin : descriptor.getPlugins().values()) {
            Class<?> aClass = plugin.getClass();
            ApplicationPlugin o = plugin;
            injector.bindBean(aClass, null, o);
        }
        for (BeanDescriptor bean : descriptor.getBeans()) {
            bean.bind(injector);
        }
        Filter filter = new Filter<Class<?>>(){
            HashSet<String> blackList = new HashSet();

            @Override
            public boolean accept(Class<?> elt) {
                if (elt.getName().startsWith("juzu.")) {
                    return false;
                }
                if (elt.getPackage().getName().startsWith(descriptor.getPackageName())) {
                    return true;
                }
                String currentPkg = elt.getPackage().getName();
                while (currentPkg != null) {
                    if (this.blackList.contains(currentPkg)) {
                        return false;
                    }
                    try {
                        Class<?> packageClass = descriptor.getApplicationLoader().loadClass(currentPkg + ".package-info");
                        juzu.Application ann = packageClass.getAnnotation(juzu.Application.class);
                        if (ann != null) {
                            this.blackList.add(currentPkg);
                            return false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    currentPkg = Tools.parentPackageOf(currentPkg);
                }
                return true;
            }
        };
        try {
            injectionContext = injector.create(filter);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        return injectionContext;
    }

    void stop() {
        if (this.assetServer != null) {
            this.assetServer.unregister(this);
        }
        Tools.safeClose(this.application);
        Tools.safeClose(this.injectionContext);
        this.application = null;
        this.injectionContext = null;
        this.stylesheetManager = null;
        this.scriptManager = null;
        this.descriptor = null;
    }

    @Override
    public void close() {
        this.stop();
    }
}

