/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import juzu.impl.common.JSON;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class JSONTestCase
extends AbstractTestCase {
    @Test
    public void testReadMap() throws Exception {
        JSON o = (JSON)JSON.parse((String)"{\"a\":\"b\"}");
        JSONTestCase.assertEquals(Collections.singleton("a"), (Object)o.names());
        JSONTestCase.assertEquals((Object)"b", (Object)o.get("a"));
    }

    @Test
    public void testWriteMap() throws Exception {
        JSONTestCase.assertEquals((String)"{\"a\":\"a_value\",\"b\":2}", (String)((StringBuilder)JSON.toString((Object)new JSON().set("a", (Object)"a_value").set("b", (Object)2), (Appendable)new StringBuilder())).toString());
    }

    @Test
    public void testReadArray() throws Exception {
        List o = (List)JSON.parse((String)"[\"a\",\"b\"]");
        JSONTestCase.assertEquals((int)2, (int)o.size());
        JSONTestCase.assertEquals((Object)"a", o.get(0));
        JSONTestCase.assertEquals((Object)"b", o.get(1));
    }

    @Test
    public void testWriteArray() throws Exception {
        JSONTestCase.assertEquals((String)"[0]", (String)((StringBuilder)JSON.toString(Arrays.asList(0), (Appendable)new StringBuilder())).toString());
    }

    @Test
    public void testWriteString() throws Exception {
        JSONTestCase.assertEquals((String)"\"a\"", (String)((StringBuilder)JSON.toString((Object)"a", (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"\"\\\"\"", (String)((StringBuilder)JSON.toString((Object)"\"", (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"\"\\n\"", (String)((StringBuilder)JSON.toString((Object)"\n", (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"\"\\r\"", (String)((StringBuilder)JSON.toString((Object)"\r", (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"\"\\b\"", (String)((StringBuilder)JSON.toString((Object)"\b", (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"\"\\f\"", (String)((StringBuilder)JSON.toString((Object)"\f", (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"\"\\t\"", (String)((StringBuilder)JSON.toString((Object)"\t", (Appendable)new StringBuilder())).toString());
    }

    @Test
    public void testWriteBoolean() throws Exception {
        JSONTestCase.assertEquals((String)"true", (String)((StringBuilder)JSON.toString((Object)true, (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"false", (String)((StringBuilder)JSON.toString((Object)false, (Appendable)new StringBuilder())).toString());
    }

    @Test
    public void testWriteNumber() throws Exception {
        JSONTestCase.assertEquals((String)"0", (String)((StringBuilder)JSON.toString((Object)0, (Appendable)new StringBuilder())).toString());
        JSONTestCase.assertEquals((String)"0", (String)((StringBuilder)JSON.toString((Object)0L, (Appendable)new StringBuilder())).toString());
    }

    @Test
    public void testToJSON() throws Exception {
        class Foo {
            final String value;

            Foo(String value) {
                this.value = value;
            }

            public JSON toJSON() {
                return new JSON().set("value", (Object)this.value);
            }
        }
        JSON json = new JSON().set("foo", (Object)new Foo("bar"));
        JSONTestCase.assertEquals(new JSON().set("value", (Object)"bar"), json.getJSON("foo"));
    }

    @Test
    public void testUnwrapArray() throws Exception {
        JSON json = new JSON().set("foo", (Object)new String[]{"bar_1", "bar_2"});
        JSONTestCase.assertEquals(Arrays.asList("bar_1", "bar_2"), json.getList("foo"));
    }

    @Test
    public void testCastToString() throws Exception {
        JSONTestCase.assertEquals((String)"bar", (String)new JSON().set("foo", (Object)"bar").getString("foo"));
        JSONTestCase.assertNull((Object)new JSON().getString("foo"));
        try {
            new JSON().set("foo", (Object)true).getString("foo");
            JSONTestCase.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testCastToList() throws Exception {
        JSONTestCase.assertEquals(Arrays.asList("bar"), new JSON().map("foo", Arrays.asList("bar")).getList("foo"));
        JSONTestCase.assertEquals(Arrays.asList("bar"), new JSON().map("foo", Arrays.asList("bar")).getList("foo", String.class));
        JSONTestCase.assertNull((Object)new JSON().getList("foo"));
        JSONTestCase.assertNull((Object)new JSON().getList("foo", Boolean.class));
        try {
            new JSON().set("foo", (Object)true).getList("foo");
            JSONTestCase.fail();
        }
        catch (ClassCastException ignore) {
            // empty catch block
        }
        try {
            new JSON().set("foo", (Object)true).getList("foo", String.class);
            JSONTestCase.fail();
        }
        catch (ClassCastException ignore) {
            // empty catch block
        }
        try {
            new JSON().map("foo", Arrays.asList("String")).getList("foo", Boolean.class);
            JSONTestCase.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testCastToJSON() throws Exception {
        JSONTestCase.assertEquals(new JSON(), new JSON().set("foo", (Object)new JSON()).getJSON("foo"));
        try {
            new JSON().set("foo", (Object)true).getJSON("foo");
            JSONTestCase.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testNull() throws Exception {
        JSON json = new JSON().set("foo", null);
        String s = json.toString();
        JSONTestCase.assertEquals((String)"{\"foo\":null}", (String)s);
        JSON unmarshalled = (JSON)JSON.parse((String)s);
        JSONTestCase.assertEquals(json, unmarshalled);
    }

    @Test
    public void testParseArray() throws Exception {
        String s = "{\"a\":[{\"b\":\"c\"}]}";
        JSON json = (JSON)JSON.parse((String)s);
        JSON expected = new JSON().set("a", Arrays.asList(new JSON().set("b", (Object)"c")));
        JSONTestCase.assertEquals(expected, json);
    }

    @Test
    public void testWriteIndented() throws Exception {
        JSONTestCase.assertEquals((String)"{\n  \"a\":\"a_value\",\n  \"b\":2,\n  \"c\":[1,2,3],\n  \"d\":{\n    \"e\":true\n  }\n}", (String)((StringBuilder)JSON.toString((Object)new JSON().set("a", (Object)"a_value").set("b", (Object)2).list("c", (Object[])new Integer[]{1, 2, 3}).set("d", (Object)new JSON().set("e", (Object)true)), (Appendable)new StringBuilder(), (int)2)).toString());
    }
}

