/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.util.ConcurrentModificationException;
import javax.naming.AuthenticationException;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.application.ApplicationException;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class ThrowableTestCase
extends AbstractInjectTestCase {
    public ThrowableTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testConstructorChecked() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.constructor.throwable.checked").init();
        MockClient client = app.client();
        try {
            client.render();
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(AuthenticationException.class, e.getCause());
        }
    }

    @Test
    public void testConstructorRuntime() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.constructor.throwable.runtime").init();
        MockClient client = app.client();
        try {
            client.render();
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(ConcurrentModificationException.class, e.getCause());
        }
    }

    @Test
    public void testConstructorError() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.constructor.throwable.error").init();
        MockClient client = app.client();
        try {
            client.render();
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(UnknownError.class, e.getCause());
        }
    }

    @Test
    public void testRenderChecked() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.render.throwable.checked").init();
        MockClient client = app.client();
        try {
            client.render();
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(AuthenticationException.class, e.getCause());
        }
    }

    @Test
    public void testRenderRuntime() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.render.throwable.runtime").init();
        MockClient client = app.client();
        try {
            client.render();
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(ConcurrentModificationException.class, e.getCause());
        }
    }

    @Test
    public void testRenderError() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.render.throwable.error").init();
        MockClient client = app.client();
        try {
            client.render();
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(UnknownError.class, e.getCause());
        }
    }

    @Test
    public void testActionChecked() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.action.throwable.checked").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        try {
            client.invoke(render.assertStringResult());
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(AuthenticationException.class, e.getCause());
        }
    }

    @Test
    public void testActionRuntime() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.action.throwable.runtime").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        try {
            client.invoke(render.assertStringResult());
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(ConcurrentModificationException.class, e.getCause());
        }
    }

    @Test
    public void testActionError() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.action.throwable.error").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        try {
            client.invoke(render.assertStringResult());
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(UnknownError.class, e.getCause());
        }
    }

    @Test
    public void testResourceChecked() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.resource.throwable.checked").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        try {
            client.invoke(render.assertStringResult());
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(AuthenticationException.class, e.getCause());
        }
    }

    @Test
    public void testResourceRuntime() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.resource.throwable.runtime").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        try {
            client.invoke(render.assertStringResult());
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(ConcurrentModificationException.class, e.getCause());
        }
    }

    @Test
    public void testResourceError() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.resource.throwable.error").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        try {
            client.invoke(render.assertStringResult());
            ThrowableTestCase.fail();
        }
        catch (ApplicationException e) {
            ThrowableTestCase.assertInstanceOf(UnknownError.class, e.getCause());
        }
    }
}

