/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Collections;
import java.util.HashMap;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouterAssert;
import org.junit.Test;

public class PortalTestCase
extends AbstractControllerTestCase {
    public static final String LANG_PATTERN = "([A-Za-z]{2}(-[A-Za-z]{2})?)?";

    @Test
    public void testLanguage1() throws Exception {
        RouterAssert router = new RouterAssert();
        router.append("/public/{gtn:lang}", Collections.singletonMap("gtn:lang", PathParam.matching((String)LANG_PATTERN).preservePath(true)));
        router.assertRoute(Collections.singletonMap("gtn:lang", ""), "/public");
        router.assertRoute(Collections.singletonMap("gtn:lang", "fr"), "/public/fr");
        router.assertRoute(Collections.singletonMap("gtn:lang", "fr-FR"), "/public/fr-FR");
    }

    @Test
    public void testLanguage2() throws Exception {
        RouterAssert router = new RouterAssert();
        Route r = router.append("/{gtn:lang}/public", Collections.singletonMap("gtn:lang", PathParam.matching((String)LANG_PATTERN)));
        router.assertRoute(Collections.singletonMap("gtn:lang", ""), "/public");
        PortalTestCase.assertNull((Object)router.route("/f/public"));
        router.assertRoute(Collections.singletonMap("gtn:lang", "fr"), "/fr/public");
        PortalTestCase.assertEquals((String)"/public", (String)r.matches(Collections.singletonMap("gtn:lang", "")).render());
        PortalTestCase.assertNull((Object)r.matches(Collections.singletonMap("gtn:lang", "f")));
        PortalTestCase.assertEquals((String)"/fr/public", (String)r.matches(Collections.singletonMap("gtn:lang", "fr")).render());
        PortalTestCase.assertEquals((String)"/fr-FR/public", (String)r.matches(Collections.singletonMap("gtn:lang", "fr-FR")).render());
    }

    @Test
    public void testLanguage3() throws Exception {
        RouterAssert router = new RouterAssert();
        Route r = router.append("/public/{gtn:lang}", Collections.singletonMap("gtn:lang", PathParam.matching((String)LANG_PATTERN).preservePath(true))).append("{gtn:sitename}{gtn:path}", Collections.singletonMap("gtn:path", PathParam.matching((String)".*").preservePath(true)));
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("gtn:lang", "fr");
        expectedParameters.put("gtn:sitename", "classic");
        expectedParameters.put("gtn:path", "/home");
        router.assertRoute(expectedParameters, "/public/fr/classic/home");
        expectedParameters.put("gtn:path", "");
        router.assertRoute(expectedParameters, "/public/fr/classic");
        expectedParameters.put("gtn:lang", "");
        expectedParameters.put("gtn:path", "/home");
        router.assertRoute(expectedParameters, "/public/classic/home");
    }

    @Test
    public void testJSMin() throws Exception {
        RouterAssert router = new RouterAssert();
        Route r = router.append("/foo{gtn:min}.js", Collections.singletonMap("gtn:min", PathParam.matching((String)"-(min)|").captureGroup(true)));
        router.assertRoute(Collections.singletonMap("gtn:min", "min"), "/foo-min.js");
        router.assertRoute(Collections.singletonMap("gtn:min", ""), "/foo.js");
        PortalTestCase.assertNull((Object)router.route("/foo-max.js"));
        PortalTestCase.assertEquals((String)"/foo-min.js", (String)r.matches(Collections.singletonMap("gtn:min", "min")).render());
        PortalTestCase.assertEquals((String)"/foo.js", (String)r.matches(Collections.singletonMap("gtn:min", "")).render());
        PortalTestCase.assertNull((Object)r.matches(Collections.singletonMap("gtn:min", "max")));
    }
}

