/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import juzu.test.protocol.mock.MockResourceBridge;
import org.junit.Test;

public class ResourceTestCase
extends AbstractInjectTestCase {
    public ResourceTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testNotFound() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.resource.notfound").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        MockResourceBridge resource = (MockResourceBridge)client.invoke(render.assertStringResult());
        resource.assertNotFound();
    }

    @Test
    public void testBinary() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.resource.binary").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        MockResourceBridge resource = (MockResourceBridge)client.invoke(render.assertStringResult());
        ResourceTestCase.assertEquals((String)"hello", (String)new String(resource.assertBinaryResult(), "UTF-8"));
        ResourceTestCase.assertEquals((String)"application/octet-stream", (String)resource.getMimeType());
    }
}

