/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import java.util.List;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.AbstractInjectTestCase;
import juzu.test.Identifiable;
import juzu.test.Registry;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRequestBridge;
import org.junit.Test;

public class ScopeTestCase
extends AbstractInjectTestCase {
    public ScopeTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testRequestScope() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.scope.request").init();
        MockClient client = app.client();
        MockRequestBridge request = client.render();
        List<Scoped> attributes = request.getAttributesHistory();
        ScopeTestCase.assertEquals((int)1, (int)attributes.size());
        Identifiable car = (Identifiable)attributes.iterator().next().get();
        ScopeTestCase.assertEquals((int)2, (int)car.getStatus());
        long id1 = (Long)Registry.unset("car");
        ScopeTestCase.assertEquals((long)car.getIdentityHashCode(), (long)id1);
        ScopeTestCase.assertEquals((int)1, (int)((Integer)Registry.unset("status")));
        request = client.invoke((String)Registry.unset("action"));
        attributes = request.getAttributesHistory();
        ScopeTestCase.assertEquals((int)1, (int)attributes.size());
        car = (Identifiable)attributes.iterator().next().get();
        ScopeTestCase.assertEquals((int)2, (int)car.getStatus());
        long id2 = (Long)Registry.unset("car");
        ScopeTestCase.assertNotSame((Object)id1, (Object)id2);
        ScopeTestCase.assertEquals((long)id2, (long)id2);
        ScopeTestCase.assertEquals((int)1, (int)((Integer)Registry.unset("status")));
        request = client.invoke((String)Registry.unset("resource"));
        attributes = request.getAttributesHistory();
        ScopeTestCase.assertEquals((int)1, (int)attributes.size());
        car = (Identifiable)attributes.iterator().next().get();
        ScopeTestCase.assertEquals((int)2, (int)car.getStatus());
        long id3 = (Long)Registry.unset("car");
        ScopeTestCase.assertNotSame((Object)id1, (Object)id3);
        ScopeTestCase.assertNotSame((Object)id2, (Object)id3);
        ScopeTestCase.assertEquals((long)car.getIdentityHashCode(), (long)id3);
        ScopeTestCase.assertEquals((int)1, (int)((Integer)Registry.unset("status")));
    }

    @Test
    public void testFlashScope() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.scope.flash").init();
        MockClient client = app.client();
        client.render();
        long id1 = (Long)Registry.unset("car");
        int status = (Integer)Registry.unset("status");
        ScopeTestCase.assertEquals((int)1, (int)status);
        ScopeTestCase.assertEquals((int)1, (int)client.getFlashHistory(1).size());
        Identifiable car1 = (Identifiable)client.getFlashHistory(1).iterator().next().get();
        ScopeTestCase.assertEquals((long)car1.getIdentityHashCode(), (long)id1);
        ScopeTestCase.assertEquals((int)2, (int)car1.getStatus());
        client.invoke((String)Registry.unset("action"));
        long id2 = (Long)Registry.unset("car");
        status = (Integer)Registry.unset("status");
        ScopeTestCase.assertEquals((int)1, (int)status);
        ScopeTestCase.assertNotSame((Object)id1, (Object)id2);
        ScopeTestCase.assertEquals((int)1, (int)client.getFlashHistory(0).size());
        Identifiable car2 = (Identifiable)client.getFlashHistory(0).iterator().next().get();
        ScopeTestCase.assertNotSame((Object)car1, (Object)car2);
        ScopeTestCase.assertEquals((int)1, (int)car2.getStatus());
        client.render();
        long id3 = (Long)Registry.unset("car");
        status = (Integer)Registry.unset("status");
        ScopeTestCase.assertEquals((int)1, (int)status);
        ScopeTestCase.assertEquals((long)id2, (long)id3);
        ScopeTestCase.assertEquals((int)1, (int)client.getFlashHistory(1).size());
        Identifiable car3 = (Identifiable)client.getFlashHistory(1).iterator().next().get();
        ScopeTestCase.assertSame((Object)car2, (Object)car3);
        ScopeTestCase.assertEquals((int)2, (int)car2.getStatus());
    }

    @Test
    public void testSessionScope() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.scope.session").init();
        MockClient client = app.client();
        client.render();
        long id1 = (Long)Registry.unset("car");
        int status = (Integer)Registry.unset("status");
        ScopeTestCase.assertEquals((int)1, (int)status);
        ScopeTestCase.assertEquals((int)1, (int)client.getSession().size());
        Identifiable car1 = (Identifiable)((Scoped)client.getSession().iterator().next()).get();
        ScopeTestCase.assertEquals((long)car1.getIdentityHashCode(), (long)id1);
        ScopeTestCase.assertEquals((int)1, (int)car1.getStatus());
        client.invoke((String)Registry.unset("action"));
        long id2 = (Long)Registry.unset("car");
        status = (Integer)Registry.unset("status");
        ScopeTestCase.assertEquals((int)1, (int)status);
        ScopeTestCase.assertNotSame((Object)id1, (Object)id2);
        ScopeTestCase.assertEquals((int)1, (int)client.getSession().size());
        Identifiable car2 = (Identifiable)((Scoped)client.getSession().iterator().next()).get();
        ScopeTestCase.assertSame((Object)car1, (Object)car2);
        ScopeTestCase.assertEquals((int)1, (int)car2.getStatus());
        client.render();
        long id3 = (Long)Registry.unset("car");
        status = (Integer)Registry.unset("status");
        ScopeTestCase.assertEquals((int)1, (int)status);
        ScopeTestCase.assertEquals((long)id2, (long)id3);
        ScopeTestCase.assertEquals((int)1, (int)client.getSession().size());
        Identifiable car3 = (Identifiable)((Scoped)client.getSession().iterator().next()).get();
        ScopeTestCase.assertSame((Object)car2, (Object)car3);
        ScopeTestCase.assertEquals((int)1, (int)car2.getStatus());
    }
}

