/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.inject.Provider;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import juzu.impl.common.Content;
import juzu.impl.common.FileKey;
import juzu.impl.common.Name;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.CaptureAnnotationProcessor;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.Compiler;
import juzu.impl.compiler.CompilerConfig;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.compiler.StringArray;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.metamodel.AnnotationState;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import juzu.test.JavaCompilerProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class CompilationTestCase
extends AbstractTestCase {
    private final JavaCompilerProvider compilerProvider;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({JavaCompilerProvider.JAVAC}, {JavaCompilerProvider.ECJ});
    }

    public CompilationTestCase(JavaCompilerProvider compilerProvider) {
        this.compilerProvider = compilerProvider;
    }

    @Test
    public void testErrorCodePattern() {
        this.asserNotMatch("");
        this.asserNotMatch("[]");
        this.asserNotMatch("[a]");
        this.asserNotMatch("[]()");
        this.asserNotMatch("[](a)");
        this.asserMatch("[a]()", "a", "");
        this.asserMatch("[a](b)", "a", "b");
        this.asserMatch("[ERROR_01](5,foobar)", "ERROR_01", "5,foobar");
    }

    private void asserNotMatch(String test) {
        Matcher matcher = Compiler.PATTERN.matcher(test);
        CompilationTestCase.assertFalse((String)("Was not expecting " + Compiler.PATTERN + " to match " + test), (boolean)matcher.matches());
    }

    private void asserMatch(String test, String expectedCode, String expectedArguments) {
        Matcher matcher = Compiler.PATTERN.matcher(test);
        CompilationTestCase.assertTrue((String)("Was expecting " + Compiler.PATTERN + " to match " + test), (boolean)matcher.matches());
        CompilationTestCase.assertEquals((String)expectedCode, (String)matcher.group(1));
        CompilationTestCase.assertEquals((String)expectedArguments, (String)matcher.group(2));
    }

    @Test
    public void testBar() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("compiler.disk").with(this.compilerProvider);
        helper.with((Provider<Processor>)((Provider)null));
        helper.assertCompile();
        CompilationTestCase.assertEquals((int)1, (int)helper.getClassOutput().size(1));
    }

    @Test
    public void testGetResourceFromProcessor() throws Exception {
        DiskFileSystem input = CompilationTestCase.diskFS("compiler.getresource");
        RAMFileSystem output = new RAMFileSystem();
        Compiler compiler = Compiler.builder().javaCompiler(this.compilerProvider.get()).sourcePath((ReadFileSystem)input).output((ReadWriteFileSystem)output).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @SupportedAnnotationTypes(value={"*"})
        @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
        class ProcessorImpl
        extends AbstractProcessor {
            Object result = null;

            ProcessorImpl() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                if (roundEnv.processingOver()) {
                    try {
                        Filer filer = this.processingEnv.getFiler();
                        FileObject o = filer.getResource(StandardLocation.SOURCE_PATH, "compiler.getresource", "A.txt");
                        this.result = o.getCharContent(false);
                    }
                    catch (IOException e) {
                        this.result = e;
                    }
                }
                return false;
            }
        }
        ProcessorImpl processor = new ProcessorImpl();
        compiler.addAnnotationProcessor((Processor)processor);
        compiler.compile();
        CompilationTestCase.assertEquals((int)1, (int)output.size(1));
        if (processor.result instanceof Exception) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)processor.result);
            throw afe;
        }
        if (processor.result instanceof CharSequence) {
            CompilationTestCase.assertEquals((String)"value", (String)processor.result.toString());
        } else {
            CompilationTestCase.fail((String)("Was not expecting result to be " + processor.result));
        }
    }

    public void _testChange() throws Exception {
        RAMFileSystem ramFS = new RAMFileSystem();
        String[] root = ramFS.getRoot();
        String[] foo = ramFS.makePath(root, "foo");
        String[] a = ramFS.makePath(foo, "A.java");
        ramFS.setContent(a, new Content((CharSequence)"package foo; public class A {}"));
        String[] b = ramFS.makePath(foo, "B.java");
        ramFS.setContent(b, new Content((CharSequence)"package foo; public class B {}"));
        RAMFileSystem output = new RAMFileSystem();
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)ramFS).output((ReadWriteFileSystem)output).build();
        compiler.compile();
        CompilationTestCase.assertEquals((int)2, (int)output.size(1));
        Timestamped aClass = output.getContent(new String[]{"foo", "A"});
        CompilationTestCase.assertNotNull((Object)aClass);
        Timestamped bClass = output.getContent(new String[]{"foo", "B"});
        CompilationTestCase.assertNotNull((Object)bClass);
        while (true) {
            ramFS.setContent(b, new Content((CharSequence)"package foo; public class B extends A {}"));
            if (bClass.getTime() < ramFS.getLastModified(b)) break;
            Thread.sleep(1L);
        }
        compiler.compile();
        CompilationTestCase.assertEquals((int)1, (int)output.size(1));
        bClass = output.getContent(new String[]{"foo", "B"});
        CompilationTestCase.assertNotNull((Object)bClass);
    }

    @Test
    public void testProcessor() throws Exception {
        ProcessorImpl processor = new ProcessorImpl();
        CompilerAssert<File, File> compiler = this.compiler("compiler.processor").with(this.compilerProvider).with(processor);
        compiler.assertCompile();
        CompilationTestCase.assertEquals((int)2, (int)compiler.getClassOutput().size(1));
        CompilationTestCase.assertEquals(Arrays.asList("compiler.processor.A", "compiler.processor.B"), processor.names);
        CompilationTestCase.assertEquals((int)1, (int)compiler.getSourceOutput().size(1));
    }

    @Test
    public void testCompilationFailure() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("compiler.failure");
        CompilationTestCase.assertEquals((int)1, (int)compiler.failCompile().size());
    }

    @Test
    public void testProcessorErrorOnElement() throws Exception {
        DiskFileSystem fs = CompilationTestCase.diskFS("compiler.annotationexception");
        Compiler compiler = Compiler.builder().javaCompiler(this.compilerProvider.get()).sourcePath((ReadFileSystem)fs).output((ReadWriteFileSystem)new RAMFileSystem()).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
        @SupportedAnnotationTypes(value={"*"})
        class Processor1
        extends AbstractProcessor {
            Processor1() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Deprecated.class);
                if (elements.size() == 1) {
                    Element elt = elements.iterator().next();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "the_message", elt);
                }
                return false;
            }
        }
        compiler.addAnnotationProcessor((Processor)new Processor1());
        try {
            compiler.compile();
            CompilationTestCase.fail();
        }
        catch (CompilationException e) {
            List errors = e.getErrors();
            CompilationTestCase.assertEquals((int)1, (int)errors.size());
            CompilationError error = (CompilationError)errors.get(0);
            CompilationTestCase.assertEquals(null, (Object)error.getCode());
            CompilationTestCase.assertEquals(Collections.emptyList(), error.getArguments());
            CompilationTestCase.assertEquals((Object)fs.getPath(new String[]{"compiler", "annotationexception", "A.java"}), (Object)error.getSourceFile());
            CompilationTestCase.assertTrue((boolean)error.getMessage().contains("the_message"));
            CompilationTestCase.assertNotNull((Object)error.getSourceFile());
            CompilationTestCase.assertNotNull((Object)error.getLocation());
            String absolutePath = error.getSourceFile().getAbsolutePath();
            char separator = File.separatorChar;
            String[] absoluteNames = Tools.split((CharSequence)absolutePath, (char)separator);
            CompilationTestCase.assertTrue((String)("Was expecting " + absolutePath + " to have at least three names "), (absoluteNames.length > 3 ? 1 : 0) != 0);
            CompilationTestCase.assertEquals((String)("Was expecting " + absolutePath + " to end with compiler/annotationexceptions/A.java"), Arrays.asList("compiler", "annotationexception", "A.java"), Arrays.asList(absoluteNames).subList(absoluteNames.length - 3, absoluteNames.length));
        }
    }

    @Test
    public void testProcessorError() throws Exception {
        if (this.compilerProvider == JavaCompilerProvider.JAVAC) {
            DiskFileSystem fs = CompilationTestCase.diskFS("compiler.annotationexception");
            Compiler compiler = Compiler.builder().javaCompiler(this.compilerProvider.get()).sourcePath((ReadFileSystem)fs).output((ReadWriteFileSystem)new RAMFileSystem()).build();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
            @SupportedAnnotationTypes(value={"*"})
            class Processor2
            extends AbstractProcessor {
                boolean failed = false;

                Processor2() {
                }

                @Override
                public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                    if (!this.failed) {
                        this.failed = true;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "the_message");
                    }
                    return false;
                }
            }
            compiler.addAnnotationProcessor((Processor)new Processor2());
            try {
                compiler.compile();
            }
            catch (CompilationException e) {
                List errors = e.getErrors();
                CompilationTestCase.assertEquals((int)1, (int)errors.size());
                CompilationError error = (CompilationError)errors.get(0);
                CompilationTestCase.assertEquals(null, (Object)error.getCode());
                CompilationTestCase.assertEquals(Collections.emptyList(), error.getArguments());
                CompilationTestCase.assertEquals(null, (String)error.getSource());
                CompilationTestCase.assertTrue((boolean)error.getMessage().contains("the_message"));
                CompilationTestCase.assertNull((Object)error.getSourceFile());
                CompilationTestCase.assertNull((Object)error.getLocation());
            }
        }
    }

    @Test
    public void testErrorCode() throws IOException {
        final MessageCode code = new MessageCode("ERROR_01", "The error");
        DiskFileSystem fs = CompilationTestCase.diskFS("compiler.errorcode");
        Compiler compiler = Compiler.builder().javaCompiler(this.compilerProvider.get()).config(new CompilerConfig().withProcessorOption("juzu.error_reporting", "formal")).sourcePath((ReadFileSystem)fs).output((ReadWriteFileSystem)new RAMFileSystem()).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class P
        extends BaseProcessor {
            P() {
            }

            protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws ProcessingException {
                if (roundEnv.processingOver()) {
                    throw new ProcessingException(code, new Object[]{5, "foobar"});
                }
            }
        }
        P processor = new P();
        compiler.addAnnotationProcessor((Processor)((Object)processor));
        try {
            compiler.compile();
        }
        catch (CompilationException e) {
            List errors = e.getErrors();
            CompilationTestCase.assertEquals((int)1, (int)errors.size());
            CompilationError error = (CompilationError)errors.get(0);
            CompilationTestCase.assertEquals((Object)code, (Object)error.getCode());
            CompilationTestCase.assertEquals(Arrays.asList("5", "foobar"), error.getArguments());
        }
    }

    @Test
    public void testIncremental() throws IOException, CompilationException {
        CompilerAssert<File, File> compiler = CompilationTestCase.compiler(true, Name.parse((CharSequence)"compiler.incremental"), "").with(this.compilerProvider).with((Provider<Processor>)((Provider)null));
        compiler.assertCompile();
        ReadWriteFileSystem<File> classOutput = compiler.getClassOutput();
        CompilationTestCase.assertEquals((int)1, (int)classOutput.size(1));
        ReadWriteFileSystem sourcePath = (ReadWriteFileSystem)compiler.getSourcePath();
        File b = (File)sourcePath.makePath(sourcePath.getPath(new String[]{"compiler", "incremental"}), "B.java");
        sourcePath.setContent((Object)b, new Content((CharSequence)"package compiler.incremental; public class B extends A {}"));
        compiler.addClassPath((ReadFileSystem<?>)classOutput);
        compiler.assertCompile();
        CompilationTestCase.assertEquals((int)2, (int)classOutput.size(1));
    }

    @Test
    public void testSourceOutputResource() throws IOException, CompilationException {
        this.testResource(StandardLocation.SOURCE_OUTPUT);
    }

    @Test
    public void testClassOutputResource() throws IOException, CompilationException {
        this.testResource(StandardLocation.CLASS_OUTPUT);
    }

    private void testResource(StandardLocation location) throws IOException, CompilationException {
        ReadWriteFileSystem<File> output;
        CompilerAssert<File, File> compiler = this.compiler("compiler.missingresource").with(this.compilerProvider).with(new ReadResource(location));
        switch (location) {
            case SOURCE_OUTPUT: {
                output = compiler.getSourceOutput();
                break;
            }
            case CLASS_OUTPUT: {
                output = compiler.getClassOutput();
                break;
            }
            default: {
                throw CompilationTestCase.failure("was not expecting " + location);
            }
        }
        File foo = (File)output.makePath(output.getRoot(), "foo.txt");
        output.setContent((Object)foo, new Content((CharSequence)"foo_value"));
        compiler.assertCompile();
        File root = (File)output.getRoot();
        HashMap<String, File> children = new HashMap<String, File>();
        Iterator i = output.getChildren((Object)root);
        while (i.hasNext()) {
            File path = (File)i.next();
            if (!output.isFile((Object)path)) continue;
            children.put(output.getName((Object)path), path);
        }
        CompilationTestCase.assertEquals((int)2, (int)children.size());
        foo = (File)children.get("foo.txt");
        CompilationTestCase.assertEquals((Object)"new_foo_value", (Object)((Content)output.getContent((Object)foo).getObject()).getCharSequence(Charset.defaultCharset()));
        File juu = (File)children.get("juu.txt");
        CompilationTestCase.assertEquals((String)"juu_value", (String)((Content)output.getContent((Object)juu).getObject()).getCharSequence(Charset.defaultCharset()).toString());
    }

    @Test
    public void testAnnotationState() {
        CaptureAnnotationProcessor processor = new CaptureAnnotationProcessor().with(StringArray.class);
        this.compiler("compiler.annotationstate.multivalued").with(this.compilerProvider).with(processor).assertCompile();
        AnnotationState m1 = processor.get((ElementHandle<?>)ElementHandle.Method.create((String)"compiler.annotationstate.multivalued.A", (String)"m1", (String[])new String[0]), StringArray.class);
        CompilationTestCase.assertTrue((boolean)m1.isUndeclared("value"));
        List value = CompilationTestCase.assertInstanceOf(List.class, m1.safeGet("value"));
        CompilationTestCase.assertNull((Object)m1.get((Object)"value"));
        CompilationTestCase.assertEquals(Collections.emptyList(), value);
        AnnotationState m2 = processor.get((ElementHandle<?>)ElementHandle.Method.create((String)"compiler.annotationstate.multivalued.A", (String)"m2", (String[])new String[0]), StringArray.class);
        CompilationTestCase.assertTrue((boolean)m2.isDeclared("value"));
        value = CompilationTestCase.assertInstanceOf(List.class, m2.safeGet("value"));
        CompilationTestCase.assertSame((Object)value, (Object)m2.get((Object)"value"));
        CompilationTestCase.assertEquals(Collections.emptyList(), value);
        AnnotationState m3 = processor.get((ElementHandle<?>)ElementHandle.Method.create((String)"compiler.annotationstate.multivalued.A", (String)"m3", (String[])new String[0]), StringArray.class);
        CompilationTestCase.assertTrue((boolean)m3.isDeclared("value"));
        value = CompilationTestCase.assertInstanceOf(List.class, m3.safeGet("value"));
        CompilationTestCase.assertSame((Object)value, (Object)m3.get((Object)"value"));
        CompilationTestCase.assertEquals(Arrays.asList("warning_value"), value);
        AnnotationState m4 = processor.get((ElementHandle<?>)ElementHandle.Method.create((String)"compiler.annotationstate.multivalued.A", (String)"m4", (String[])new String[0]), StringArray.class);
        CompilationTestCase.assertTrue((boolean)m4.isDeclared("value"));
        value = CompilationTestCase.assertInstanceOf(List.class, m4.safeGet("value"));
        CompilationTestCase.assertSame((Object)value, (Object)m4.get((Object)"value"));
        CompilationTestCase.assertEquals(Arrays.asList("warning_value"), value);
        AnnotationState m5 = processor.get((ElementHandle<?>)ElementHandle.Method.create((String)"compiler.annotationstate.multivalued.A", (String)"m5", (String[])new String[0]), StringArray.class);
        CompilationTestCase.assertTrue((boolean)m5.isDeclared("value"));
        value = CompilationTestCase.assertInstanceOf(List.class, m5.safeGet("value"));
        CompilationTestCase.assertSame((Object)value, (Object)m5.get((Object)"value"));
        CompilationTestCase.assertEquals(Arrays.asList("warning_value_1", "warning_value_2"), value);
    }

    @Test
    public void testDot() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("compiler.dot").with(this.compilerProvider);
        compiler.with(new AbstractProcessor(){
            int count = 0;

            @Override
            public Set<String> getSupportedAnnotationTypes() {
                return Collections.singleton("*");
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                if (this.count++ == 0) {
                    try {
                        ProcessingContext ctx = new ProcessingContext(this.processingEnv);
                        ElementHandle.Package pkg = ElementHandle.Package.create((PackageElement)ctx.getPackageElement((CharSequence)"compiler.dot.foo"));
                        FileObject file = ctx.resolveResource(pkg, FileKey.newName((String)"compiler.dot.foo", (String)"a.b.txt"));
                        InputStream in = file.openInputStream();
                        FileObject o = ctx.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, FileKey.newName((String)"compiler.dot.foo", (String)"a.b.css"), new Element[0]);
                        OutputStream out = o.openOutputStream();
                        Tools.copy((InputStream)in, (OutputStream)out);
                        Tools.safeClose((Closeable)in);
                        Tools.safeClose((Closeable)out);
                    }
                    catch (Exception e) {
                        throw AbstractTestCase.failure(e);
                    }
                }
                return true;
            }
        });
        compiler.assertCompile();
        ReadWriteFileSystem<File> classOutput = compiler.getClassOutput();
        File f = new File((File)classOutput.getRoot(), "compiler/dot/foo/a.b.css");
        FileInputStream in = new FileInputStream(f);
        String content = Tools.read((InputStream)in);
        ((InputStream)in).close();
        CompilationTestCase.assertEquals((String)"content", (String)content.trim());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @SupportedAnnotationTypes(value={"*"})
    @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
    public static class ReadResource
    extends AbstractProcessor {
        private final StandardLocation location;
        private ProcessingContext processingContext;

        public ReadResource(StandardLocation location) {
            this.location = location;
        }

        @Override
        public synchronized void init(ProcessingEnvironment processingEnv) {
            super.init(processingEnv);
            this.processingContext = new ProcessingContext(processingEnv);
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            try {
                return this._process(annotations, roundEnv);
            }
            catch (IOException e) {
                throw AbstractTestCase.failure(e);
            }
        }

        private boolean _process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
            if (roundEnv.processingOver()) {
                FileObject foo = this.processingContext.getResource((JavaFileManager.Location)this.location, (CharSequence)"", (CharSequence)"foo.txt");
                Assert.assertNotNull((Object)foo);
                String s = Tools.read((InputStream)foo.openInputStream());
                Assert.assertEquals((String)"foo_value", (String)s);
                foo = this.processingContext.createResource((JavaFileManager.Location)this.location, (CharSequence)"", (CharSequence)"foo.txt", new Element[0]);
                OutputStream out = foo.openOutputStream();
                out.write("new_foo_value".getBytes());
                out.close();
                FileObject bar = this.processingContext.getResource((JavaFileManager.Location)this.location, (CharSequence)"", (CharSequence)"bar.txt");
                Assert.assertNull((Object)bar);
                foo = this.processingContext.createResource((JavaFileManager.Location)this.location, (CharSequence)"", (CharSequence)"juu.txt", new Element[0]);
                out = foo.openOutputStream();
                out.write("juu_value".getBytes());
                out.close();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @SupportedAnnotationTypes(value={"*"})
    @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
    public static class ProcessorImpl
    extends AbstractProcessor {
        final List<String> names = new ArrayList<String>();
        private boolean done;

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            for (Element element : roundEnv.getRootElements()) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElt = (TypeElement)element;
                this.names.add(typeElt.getQualifiedName().toString());
            }
            if (!this.done) {
                try {
                    Filer filer = this.processingEnv.getFiler();
                    JavaFileObject javaFileObject = filer.createSourceFile("compiler.processor.B", new Element[0]);
                    PrintWriter writer = new PrintWriter(javaFileObject.openWriter());
                    writer.println("package compiler.processor; public class B { }");
                    writer.close();
                    this.done = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}

