/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.url;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.Portlet;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.url.Node;
import juzu.impl.fs.spi.url.URLFileSystem;
import juzu.test.AbstractTestCase;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLFileSystemTestCase
extends AbstractTestCase {
    private JavaArchive jar;

    public URLFileSystemTestCase() {
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.setManifest((Asset)new StringAsset(""));
        jar.addAsResource((Asset)new StringAsset("bar.txt_value"), "bar.txt");
        jar.addAsResource((Asset)new StringAsset("foo/bar.txt_value"), "foo/bar.txt");
        jar.addAsResource((Asset)new StringAsset("foo/bar/juu.txt_value"), "foo/bar/juu.txt");
        this.jar = jar;
    }

    @Test
    public void testJarFile() throws Exception {
        File f = File.createTempFile("test", ".jar");
        f.deleteOnExit();
        ((ZipExporter)this.jar.as(ZipExporter.class)).exportTo(f, true);
        this.assertFS(f.toURI().toURL());
    }

    @Test
    public void testJar() throws Exception {
        File tmp = File.createTempFile("juzu", ".jar");
        tmp.deleteOnExit();
        FileOutputStream baos = new FileOutputStream(tmp);
        ((ZipExporter)this.jar.as(ZipExporter.class)).exportTo((OutputStream)baos);
        URL url = new URL("jar:" + tmp.toURI().toURL() + "!/foo/bar.txt_value");
        this.assertFS(url);
    }

    @Test
    public void testFile() throws Exception {
        File f = File.createTempFile("test", "");
        URLFileSystemTestCase.assertTrue((boolean)f.delete());
        URLFileSystemTestCase.assertTrue((boolean)f.mkdirs());
        f.deleteOnExit();
        File dir = ((ExplodedExporter)this.jar.as(ExplodedExporter.class)).exportExploded(f);
        this.assertFS(dir.toURI().toURL());
    }

    @Test
    public void testFromClassLoaderWithJar() throws Exception {
        File f = File.createTempFile("test", ".jar");
        f.deleteOnExit();
        ((ZipExporter)this.jar.as(ZipExporter.class)).exportTo(f, true);
        URLClassLoader loader = new URLClassLoader(new URL[]{f.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        URLFileSystem fs = new URLFileSystem();
        fs.add((ClassLoader)loader);
        this.assertFS((ReadFileSystem)fs);
    }

    @Test
    public void testFromClassLoaderWithFile() throws Exception {
        File f = File.createTempFile("test", "");
        URLFileSystemTestCase.assertTrue((boolean)f.delete());
        URLFileSystemTestCase.assertTrue((boolean)f.mkdirs());
        f.deleteOnExit();
        File dir = ((ExplodedExporter)this.jar.as(ExplodedExporter.class)).exportExploded(f);
        URLClassLoader loader = new URLClassLoader(new URL[]{dir.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        URLFileSystem fs = new URLFileSystem();
        fs.add((ClassLoader)loader);
        this.assertFS((ReadFileSystem)fs);
    }

    private void assertFS(URL url) throws Exception {
        URLFileSystem fs = new URLFileSystem();
        fs.add(url);
        this.assertFS((ReadFileSystem)fs);
    }

    private <P> void assertFS(ReadFileSystem<P> fs) throws Exception {
        Object foo = fs.getPath(new String[]{"foo"});
        URLFileSystemTestCase.assertEquals((String)"foo", (String)fs.getName(foo));
        ArrayList fooChildren = Tools.list((Iterator)fs.getChildren(foo));
        URLFileSystemTestCase.assertEquals((int)1, (int)fooChildren.size());
        Object fooChild = fooChildren.get(0);
        URLFileSystemTestCase.assertEquals((String)"bar.txt", (String)fs.getName(fooChild));
        Object fooBar = fs.getPath(new String[]{"foo", "bar.txt"});
        URLFileSystemTestCase.assertEquals((String)"bar.txt", (String)fs.getName(fooBar));
        URL fooBarURL = fs.getURL(fooBar);
        String fooBarContent = Tools.read((URL)fooBarURL);
        URLFileSystemTestCase.assertEquals((String)"foo/bar.txt_value", (String)fooBarContent);
        Object fooBarJuu = fs.getPath(new String[]{"foo", "bar", "juu.txt"});
        URLFileSystemTestCase.assertEquals((String)"juu.txt", (String)fs.getName(fooBarJuu));
        URL fooBarJuuURL = fs.getURL(fooBarJuu);
        String fooBarJuuContent = Tools.read((URL)fooBarJuuURL);
        URLFileSystemTestCase.assertEquals((String)"foo/bar/juu.txt_value", (String)fooBarJuuContent);
        URLFileSystemTestCase.assertEquals(null, (Object)fs.getPath(new String[]{"juu"}));
    }

    @Test
    public void testPortletJar() throws Exception {
        URL url = Portlet.class.getProtectionDomain().getCodeSource().getLocation();
        URLFileSystem fs = new URLFileSystem();
        fs.add(url);
        Object s = fs.getPath(new String[]{"javax", "portlet"});
        URLFileSystemTestCase.assertNotNull((Object)s);
    }

    @Test
    public void testInheritance() throws Exception {
        URLClassLoader loader = new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
        URLFileSystem fs = new URLFileSystem();
        fs.add((ClassLoader)loader, ClassLoader.getSystemClassLoader().getParent());
        Node assertClass = (Node)fs.getPath(new String[]{"junit", "framework", "Assert.class"});
        URLFileSystemTestCase.assertNotNull((Object)assertClass);
    }
}

