/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.io.File;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.controller.descriptor.ControllerDescriptor;
import juzu.impl.request.Method;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ApplicationTestCase
extends AbstractTestCase {
    @Test
    public void testDefaultController() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.application.default_controller");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.application.default_controller.Application");
        Class<?> aClass = compiler.assertClass("plugin.application.default_controller.A");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ApplicationTestCase.assertSame(aClass, (Object)desc.getControllers().getDefault());
    }

    public void _testMethodId() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.application.method.id");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.application.method.id.Application");
        Class<?> aClass = compiler.assertClass("plugin.application.method.id.A");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        Method a = desc.getControllers().getMethod(aClass, "a", new Class[0]);
        Method b = desc.getControllers().getMethod(aClass, "b", new Class[0]);
        Method c = desc.getControllers().getMethod(aClass, "c", new Class[0]);
        ApplicationTestCase.assertEquals((String)"foo", (String)a.getId());
        ApplicationTestCase.assertEquals((String)"bar", (String)b.getId());
        ApplicationTestCase.assertEquals((String)"juu", (String)c.getId());
        ApplicationTestCase.assertSame((Object)a, (Object)desc.getControllers().getMethodById("foo"));
        ApplicationTestCase.assertSame((Object)b, (Object)desc.getControllers().getMethodById("bar"));
        ApplicationTestCase.assertSame((Object)c, (Object)desc.getControllers().getMethodById("juu"));
    }

    public void _testDuplicateMethod() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.application.method.duplicate");
        List<CompilationError> errors = compiler.failCompile();
        ApplicationTestCase.assertEquals((String)("Was expecting a single error instead of " + errors), (int)1, (int)errors.size());
        ApplicationTestCase.assertEquals((String)"/plugin/application/method/duplicate/A.java", (String)errors.get(0).getSource());
    }

    public void _testPrefix() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.application.prefix");
        compiler.assertCompile();
    }

    @Test
    public void testMultiple() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.application.multiple");
        compiler.assertCompile();
        Class<?> app1Class = compiler.assertClass("plugin.application.multiple.app1.Application");
        Class<?> a1Class = compiler.assertClass("plugin.application.multiple.app1.A");
        ApplicationDescriptor desc1 = ApplicationDescriptor.create(app1Class);
        ApplicationTestCase.assertSame(a1Class, (Object)((ControllerDescriptor)desc1.getControllers().getControllers().get(0)).getType());
        Class<?> app2Class = compiler.assertClass("plugin.application.multiple.app2.Application");
        Class<?> a2Class = compiler.assertClass("plugin.application.multiple.app2.A");
        ApplicationDescriptor desc2 = ApplicationDescriptor.create(app2Class);
        ApplicationTestCase.assertSame(a2Class, (Object)((ControllerDescriptor)desc2.getControllers().getControllers().get(0)).getType());
    }
}

