/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.io.File;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.binding.BindingMetaModelPlugin;
import juzu.test.AbstractInjectTestCase;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class BindingImplementationTestCase
extends AbstractInjectTestCase {
    public BindingImplementationTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testNotAssignable() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.implementation.notassignable");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingImplementationTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingImplementationTestCase.assertEquals((Object)BindingMetaModelPlugin.IMPLEMENTATION_NOT_ASSIGNABLE, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "implementation", "notassignable", "package-info.java"});
        BindingImplementationTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testAbstractClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.implementation.abstractclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingImplementationTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingImplementationTestCase.assertEquals((Object)BindingMetaModelPlugin.IMPLEMENTATION_NOT_ABSTRACT, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "implementation", "abstractclass", "package-info.java"});
        BindingImplementationTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testCreate() throws Exception {
        MockApplication<File> app = this.application("plugin.binding.implementation.create").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        BindingImplementationTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }
}

