/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import juzu.impl.common.JSON;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.module.ModulePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module {
    private final HashMap<String, ModulePlugin> plugins;
    private final HashMap<String, Descriptor> descriptors;

    public Module(ClassLoader loader, JSON config) throws Exception {
        HashMap<String, ModulePlugin> plugins = new HashMap<String, ModulePlugin>();
        for (ModulePlugin plugin : ServiceLoader.load(ModulePlugin.class)) {
            plugins.put(plugin.getName(), plugin);
        }
        HashMap<String, Descriptor> descriptors = new HashMap<String, Descriptor>();
        for (ModulePlugin plugin : plugins.values()) {
            JSON pluginConfig;
            Descriptor desc = plugin.init(loader, pluginConfig = config.getJSON(plugin.getName()));
            if (desc == null) continue;
            descriptors.put(plugin.getName(), desc);
        }
        this.plugins = plugins;
        this.descriptors = descriptors;
    }

    public ModulePlugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public <P extends ModulePlugin> P getPlugin(Class<P> type) {
        for (ModulePlugin plugin : this.plugins.values()) {
            if (!type.isInstance(plugin)) continue;
            return (P)((ModulePlugin)type.cast(plugin));
        }
        return null;
    }

    public Map<String, Descriptor> getDescriptors() {
        return this.descriptors;
    }
}

