/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import juzu.Mapped;
import juzu.Param;
import juzu.impl.common.Cardinality;
import juzu.impl.common.JSON;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.controller.metamodel.ContextualParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.MethodMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.PhaseParameterMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerMetaModel
extends MetaModelObject
implements Iterable<MethodMetaModel> {
    public static final MessageCode CANNOT_WRITE_CONTROLLER_COMPANION = new MessageCode("CANNOT_WRITE_CONTROLLER_COMPANION", "The controller companion %1$s cannot be written");
    public static final MessageCode CONTROLLER_METHOD_NOT_RESOLVED = new MessageCode("CONTROLLER_METHOD_NOT_RESOLVED", "The controller method cannot be resolved %1$s");
    public static final MessageCode CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED = new MessageCode("CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED", "The method parameter type %1s should be a string or annotated with @juzu.Param");
    boolean modified;
    ControllersMetaModel controllers;
    final ElementHandle.Class handle;

    public ControllerMetaModel(ElementHandle.Class handle) {
        this.handle = handle;
        this.modified = false;
    }

    @Override
    public Iterator<MethodMetaModel> iterator() {
        return this.getMethods().iterator();
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("handle", this.handle);
        json.map("methods", this.getMethods());
        return json;
    }

    public ControllersMetaModel getControllers() {
        return this.controllers;
    }

    public ElementHandle.Class getHandle() {
        return this.handle;
    }

    public Collection<MethodMetaModel> getMethods() {
        return this.getChildren(MethodMetaModel.class);
    }

    public void remove(ElementHandle.Method handle) {
        this.removeChild(Key.of(handle, MethodMetaModel.class));
    }

    /*
     * WARNING - void declaration
     */
    void addMethod(ModuleMetaModel context, AnnotationKey key2, AnnotationState annotation) {
        String id = (String)annotation.get("id");
        ExecutableElement methodElt = (ExecutableElement)context.processingContext.get(key2.getElement());
        for (Phase phase : Phase.values()) {
            if (!phase.annotation.getName().equals(key2.getType().toString())) continue;
            ElementHandle.Method origin = (ElementHandle.Method)key2.getElement();
            Key<MethodMetaModel> key = Key.of(origin, MethodMetaModel.class);
            if (this.getChild(key) != null) break;
            ArrayList<ParameterMetaModel> parameters = new ArrayList<ParameterMetaModel>();
            List<? extends TypeMirror> parameterTypeMirrors = ((ExecutableType)methodElt.asType()).getParameterTypes();
            List<? extends VariableElement> parameterVariableElements = methodElt.getParameters();
            for (int i = 0; i < parameterTypeMirrors.size(); ++i) {
                void var19_20;
                Cardinality parameterCardinality;
                VariableElement parameterVariableElt = parameterVariableElements.get(i);
                TypeMirror parameterTypeMirror = parameterTypeMirrors.get(i);
                String typeLiteral = context.processingContext.getLiteralName(parameterTypeMirror);
                String pattern = null;
                for (AnnotationMirror annotationMirror : parameterVariableElt.getAnnotationMirrors()) {
                    boolean match = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(Param.class.getName());
                    if (!match) continue;
                    AnnotationState state = AnnotationState.create(annotationMirror);
                    pattern = (String)state.get("pattern");
                }
                String parameterName = parameterVariableElt.getSimpleName().toString();
                switch (parameterTypeMirror.getKind()) {
                    case DECLARED: {
                        DeclaredType dt = (DeclaredType)parameterTypeMirror;
                        TypeElement col = context.processingContext.getTypeElement("java.util.List");
                        TypeMirror tm = context.processingContext.erasure(col.asType());
                        TypeMirror err = context.processingContext.erasure(dt);
                        if (err.equals(tm)) {
                            if (dt.getTypeArguments().size() != 1) {
                                throw CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED.failure(parameterVariableElt);
                            }
                            parameterCardinality = Cardinality.LIST;
                            TypeMirror typeMirror = dt.getTypeArguments().get(0);
                            break;
                        }
                        parameterCardinality = Cardinality.SINGLE;
                        TypeMirror typeMirror = parameterTypeMirror;
                        break;
                    }
                    case ARRAY: {
                        ArrayType arrayType = (ArrayType)parameterTypeMirror;
                        parameterCardinality = Cardinality.ARRAY;
                        TypeMirror typeMirror = arrayType.getComponentType();
                        break;
                    }
                    default: {
                        throw CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED.failure(parameterVariableElt);
                    }
                }
                if (var19_20.getKind() != TypeKind.DECLARED) {
                    throw CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED.failure(parameterVariableElt);
                }
                TypeElement te = (TypeElement)context.processingContext.asElement((TypeMirror)var19_20);
                ElementHandle.Class a = ElementHandle.Class.create(te);
                if (te.toString().equals("java.lang.String") || te.getAnnotation(Mapped.class) != null) {
                    parameters.add(new PhaseParameterMetaModel(parameterName, parameterCardinality, a, typeLiteral, pattern));
                    continue;
                }
                parameters.add(new ContextualParameterMetaModel(parameterName, typeLiteral));
            }
            MethodMetaModel method = new MethodMetaModel(origin, id, phase, methodElt.getSimpleName().toString(), parameters);
            this.addChild(key, method);
            this.modified = true;
            break;
        }
    }

    @Override
    protected void preDetach(MetaModelObject parent) {
        if (parent instanceof ControllersMetaModel) {
            this.queue(MetaModelEvent.createRemoved(this));
            this.controllers = null;
        }
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof ControllersMetaModel) {
            this.controllers = (ControllersMetaModel)parent;
            this.queue(MetaModelEvent.createAdded(this));
        }
    }
}

